% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_identity_provider}
\alias{cognitoidentityprovider_create_identity_provider}
\title{Creates an identity provider for a user pool}
\usage{
cognitoidentityprovider_create_identity_provider(UserPoolId,
  ProviderName, ProviderType, ProviderDetails, AttributeMapping,
  IdpIdentifiers)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ProviderName}{[required] The identity provider name.}

\item{ProviderType}{[required] The identity provider type.}

\item{ProviderDetails}{[required] The identity provider details. The following list describes the provider
detail keys for each identity provider type.
\itemize{
\item For Google, Facebook and Login with Amazon:
\itemize{
\item client\\_id
\item client\\_secret
\item authorize\\_scopes
}
\item For Sign in with Apple:
\itemize{
\item client\\_id
\item team\\_id
\item key\\_id
\item private\\_key
\item authorize\\_scopes
}
\item For OIDC providers:
\itemize{
\item client\\_id
\item client\\_secret
\item attributes\\_request\\_method
\item oidc\\_issuer
\item authorize\\_scopes
\item authorize\\_url \emph{if not available from discovery URL specified by
oidc\\_issuer key}
\item token\\_url \emph{if not available from discovery URL specified by
oidc\\_issuer key}
\item attributes\\_url \emph{if not available from discovery URL specified
by oidc\\_issuer key}
\item jwks\\_uri \emph{if not available from discovery URL specified by
oidc\\_issuer key}
\item authorize\\_scopes
}
\item For SAML providers:
\itemize{
\item MetadataFile OR MetadataURL
\item IDPSignout \emph{optional}
}
}}

\item{AttributeMapping}{A mapping of identity provider attributes to standard and custom user
pool attributes.}

\item{IdpIdentifiers}{A list of identity provider identifiers.}
}
\description{
Creates an identity provider for a user pool.
}
\section{Request syntax}{
\preformatted{svc$create_identity_provider(
  UserPoolId = "string",
  ProviderName = "string",
  ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"SignInWithApple"|"OIDC",
  ProviderDetails = list(
    "string"
  ),
  AttributeMapping = list(
    "string"
  ),
  IdpIdentifiers = list(
    "string"
  )
)
}
}

\keyword{internal}
