% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_computer}
\alias{directoryservice_create_computer}
\title{Creates an Active Directory computer object in the specified directory}
\usage{
directoryservice_create_computer(
  DirectoryId,
  ComputerName,
  Password,
  OrganizationalUnitDistinguishedName = NULL,
  ComputerAttributes = NULL
)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory in which to create the computer account.}

\item{ComputerName}{[required] The name of the computer account.}

\item{Password}{[required] A one-time password that is used to join the computer to the directory.
You should generate a random, strong password to use for this parameter.}

\item{OrganizationalUnitDistinguishedName}{The fully-qualified distinguished name of the organizational unit to
place the computer account in.}

\item{ComputerAttributes}{An array of Attribute objects that contain any LDAP attributes to apply
to the computer account.}
}
\description{
Creates an Active Directory computer object in the specified directory.

See \url{https://paws-r.github.io/docs/directoryservice/create_computer.html} for full documentation.
}
\keyword{internal}
