% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_upload_signing_certificate}
\alias{iam_upload_signing_certificate}
\title{Uploads an X}
\usage{
iam_upload_signing_certificate(UserName = NULL, CertificateBody)
}
\arguments{
\item{UserName}{The name of the user the signing certificate is for.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{CertificateBody}{[required] The contents of the signing certificate.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}
}
\description{
Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services services require you to use certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is \code{Active}.

See \url{https://paws-r.github.io/docs/iam/upload_signing_certificate.html} for full documentation.
}
\keyword{internal}
