% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_update_secret_version_stage}
\alias{secretsmanager_update_secret_version_stage}
\title{Modifies the staging labels attached to a version of a secret}
\usage{
secretsmanager_update_secret_version_stage(
  SecretId,
  VersionStage,
  RemoveFromVersionId = NULL,
  MoveToVersionId = NULL
)
}
\arguments{
\item{SecretId}{[required] The ARN or the name of the secret with the version and staging labelsto
modify.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{VersionStage}{[required] The staging label to add to this version.}

\item{RemoveFromVersionId}{The ID of the version that the staging label is to be removed from. If
the staging label you are trying to attach to one version is already
attached to a different version, then you must include this parameter
and specify the version that the label is to be removed from. If the
label is attached and you either do not specify this parameter, or the
version ID does not match, then the operation fails.}

\item{MoveToVersionId}{The ID of the version to add the staging label to. To remove a label
from a version, then do not specify this parameter.

If the staging label is already attached to a different version of the
secret, then you must also specify the \code{RemoveFromVersionId} parameter.}
}
\description{
Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a version as it progresses through the secret rotation process. Each staging label can be attached to only one version at a time. To add a staging label to a version when it is already attached to another version, Secrets Manager first removes it from the other version first and then attaches it to this one. For more information about versions and staging labels, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version}{Concepts: Version}.

See \url{https://paws-r.github.io/docs/secretsmanager/update_secret_version_stage.html} for full documentation.
}
\keyword{internal}
