% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_create_regex_pattern_set}
\alias{wafv2_create_regex_pattern_set}
\title{Creates a RegexPatternSet, which you reference in a
RegexPatternSetReferenceStatement, to have WAF inspect a web request
component for the specified patterns}
\usage{
wafv2_create_regex_pattern_set(
  Name,
  Scope,
  Description = NULL,
  RegularExpressionList,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the set. You cannot change the name after you create the
set.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
or an Amazon Cognito user pool.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{Description}{A description of the set that helps with identification.}

\item{RegularExpressionList}{[required] Array of regular expression strings.}

\item{Tags}{An array of key:value pairs to associate with the resource.}
}
\description{
Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.

See \url{https://paws-r.github.io/docs/wafv2/create_regex_pattern_set.html} for full documentation.
}
\keyword{internal}
