# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include detective_service.R
NULL

#' Accepts an invitation for the member account to contribute data to a
#' behavior graph
#'
#' @description
#' Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_accept_invitation/](https://www.paws-r-sdk.com/docs/detective_accept_invitation/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph that the member account is accepting the
#' invitation for.
#' 
#' The member account status in the behavior graph must be `INVITED`.
#'
#' @keywords internal
#'
#' @rdname detective_accept_invitation
detective_accept_invitation <- function(GraphArn) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "PUT",
    http_path = "/invitation",
    paginator = list()
  )
  input <- .detective$accept_invitation_input(GraphArn = GraphArn)
  output <- .detective$accept_invitation_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$accept_invitation <- detective_accept_invitation

#' Gets data source package information for the behavior graph
#'
#' @description
#' Gets data source package information for the behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_batch_get_graph_member_datasources/](https://www.paws-r-sdk.com/docs/detective_batch_get_graph_member_datasources/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph.
#' @param AccountIds &#91;required&#93; The list of Amazon Web Services accounts to get data source package
#' information on.
#'
#' @keywords internal
#'
#' @rdname detective_batch_get_graph_member_datasources
detective_batch_get_graph_member_datasources <- function(GraphArn, AccountIds) {
  op <- new_operation(
    name = "BatchGetGraphMemberDatasources",
    http_method = "POST",
    http_path = "/graph/datasources/get",
    paginator = list()
  )
  input <- .detective$batch_get_graph_member_datasources_input(GraphArn = GraphArn, AccountIds = AccountIds)
  output <- .detective$batch_get_graph_member_datasources_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$batch_get_graph_member_datasources <- detective_batch_get_graph_member_datasources

#' Gets information on the data source package history for an account
#'
#' @description
#' Gets information on the data source package history for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_batch_get_membership_datasources/](https://www.paws-r-sdk.com/docs/detective_batch_get_membership_datasources/) for full documentation.
#'
#' @param GraphArns &#91;required&#93; The ARN of the behavior graph.
#'
#' @keywords internal
#'
#' @rdname detective_batch_get_membership_datasources
detective_batch_get_membership_datasources <- function(GraphArns) {
  op <- new_operation(
    name = "BatchGetMembershipDatasources",
    http_method = "POST",
    http_path = "/membership/datasources/get",
    paginator = list()
  )
  input <- .detective$batch_get_membership_datasources_input(GraphArns = GraphArns)
  output <- .detective$batch_get_membership_datasources_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$batch_get_membership_datasources <- detective_batch_get_membership_datasources

#' Creates a new behavior graph for the calling account, and sets that
#' account as the administrator account
#'
#' @description
#' Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_create_graph/](https://www.paws-r-sdk.com/docs/detective_create_graph/) for full documentation.
#'
#' @param Tags The tags to assign to the new behavior graph. You can add up to 50 tags.
#' For each tag, you provide the tag key and the tag value. Each tag key
#' can contain up to 128 characters. Each tag value can contain up to 256
#' characters.
#'
#' @keywords internal
#'
#' @rdname detective_create_graph
detective_create_graph <- function(Tags = NULL) {
  op <- new_operation(
    name = "CreateGraph",
    http_method = "POST",
    http_path = "/graph",
    paginator = list()
  )
  input <- .detective$create_graph_input(Tags = Tags)
  output <- .detective$create_graph_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$create_graph <- detective_create_graph

#' CreateMembers is used to send invitations to accounts
#'
#' @description
#' [`create_members`][detective_create_members] is used to send invitations to accounts. For the organization behavior graph, the Detective administrator account uses [`create_members`][detective_create_members] to enable organization accounts as member accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_create_members/](https://www.paws-r-sdk.com/docs/detective_create_members/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph.
#' @param Message Customized message text to include in the invitation email message to
#' the invited member accounts.
#' @param DisableEmailNotification if set to `true`, then the invited accounts do not receive email
#' notifications. By default, this is set to `false`, and the invited
#' accounts receive email notifications.
#' 
#' Organization accounts in the organization behavior graph do not receive
#' email notifications.
#' @param Accounts &#91;required&#93; The list of Amazon Web Services accounts to invite or to enable. You can
#' invite or enable up to 50 accounts at a time. For each invited account,
#' the account list contains the account identifier and the Amazon Web
#' Services account root user email address. For organization accounts in
#' the organization behavior graph, the email address is not required.
#'
#' @keywords internal
#'
#' @rdname detective_create_members
detective_create_members <- function(GraphArn, Message = NULL, DisableEmailNotification = NULL, Accounts) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/graph/members",
    paginator = list()
  )
  input <- .detective$create_members_input(GraphArn = GraphArn, Message = Message, DisableEmailNotification = DisableEmailNotification, Accounts = Accounts)
  output <- .detective$create_members_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$create_members <- detective_create_members

#' Disables the specified behavior graph and queues it to be deleted
#'
#' @description
#' Disables the specified behavior graph and queues it to be deleted. This operation removes the behavior graph from each member account's list of behavior graphs.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_delete_graph/](https://www.paws-r-sdk.com/docs/detective_delete_graph/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph to disable.
#'
#' @keywords internal
#'
#' @rdname detective_delete_graph
detective_delete_graph <- function(GraphArn) {
  op <- new_operation(
    name = "DeleteGraph",
    http_method = "POST",
    http_path = "/graph/removal",
    paginator = list()
  )
  input <- .detective$delete_graph_input(GraphArn = GraphArn)
  output <- .detective$delete_graph_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$delete_graph <- detective_delete_graph

#' Removes the specified member accounts from the behavior graph
#'
#' @description
#' Removes the specified member accounts from the behavior graph. The removed accounts no longer contribute data to the behavior graph. This operation can only be called by the administrator account for the behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_delete_members/](https://www.paws-r-sdk.com/docs/detective_delete_members/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph to remove members from.
#' @param AccountIds &#91;required&#93; The list of Amazon Web Services account identifiers for the member
#' accounts to remove from the behavior graph. You can remove up to 50
#' member accounts at a time.
#'
#' @keywords internal
#'
#' @rdname detective_delete_members
detective_delete_members <- function(GraphArn, AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/graph/members/removal",
    paginator = list()
  )
  input <- .detective$delete_members_input(GraphArn = GraphArn, AccountIds = AccountIds)
  output <- .detective$delete_members_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$delete_members <- detective_delete_members

#' Returns information about the configuration for the organization
#' behavior graph
#'
#' @description
#' Returns information about the configuration for the organization behavior graph. Currently indicates whether to automatically enable new organization accounts as member accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_describe_organization_configuration/](https://www.paws-r-sdk.com/docs/detective_describe_organization_configuration/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the organization behavior graph.
#'
#' @keywords internal
#'
#' @rdname detective_describe_organization_configuration
detective_describe_organization_configuration <- function(GraphArn) {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "POST",
    http_path = "/orgs/describeOrganizationConfiguration",
    paginator = list()
  )
  input <- .detective$describe_organization_configuration_input(GraphArn = GraphArn)
  output <- .detective$describe_organization_configuration_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$describe_organization_configuration <- detective_describe_organization_configuration

#' Removes the Detective administrator account in the current Region
#'
#' @description
#' Removes the Detective administrator account in the current Region. Deletes the organization behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_disable_organization_admin_account/](https://www.paws-r-sdk.com/docs/detective_disable_organization_admin_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname detective_disable_organization_admin_account
detective_disable_organization_admin_account <- function() {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/orgs/disableAdminAccount",
    paginator = list()
  )
  input <- .detective$disable_organization_admin_account_input()
  output <- .detective$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$disable_organization_admin_account <- detective_disable_organization_admin_account

#' Removes the member account from the specified behavior graph
#'
#' @description
#' Removes the member account from the specified behavior graph. This operation can only be called by an invited member account that has the `ENABLED` status.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_disassociate_membership/](https://www.paws-r-sdk.com/docs/detective_disassociate_membership/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph to remove the member account from.
#' 
#' The member account's member status in the behavior graph must be
#' `ENABLED`.
#'
#' @keywords internal
#'
#' @rdname detective_disassociate_membership
detective_disassociate_membership <- function(GraphArn) {
  op <- new_operation(
    name = "DisassociateMembership",
    http_method = "POST",
    http_path = "/membership/removal",
    paginator = list()
  )
  input <- .detective$disassociate_membership_input(GraphArn = GraphArn)
  output <- .detective$disassociate_membership_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$disassociate_membership <- detective_disassociate_membership

#' Designates the Detective administrator account for the organization in
#' the current Region
#'
#' @description
#' Designates the Detective administrator account for the organization in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_enable_organization_admin_account/](https://www.paws-r-sdk.com/docs/detective_enable_organization_admin_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account identifier of the account to designate
#' as the Detective administrator account for the organization.
#'
#' @keywords internal
#'
#' @rdname detective_enable_organization_admin_account
detective_enable_organization_admin_account <- function(AccountId) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/orgs/enableAdminAccount",
    paginator = list()
  )
  input <- .detective$enable_organization_admin_account_input(AccountId = AccountId)
  output <- .detective$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$enable_organization_admin_account <- detective_enable_organization_admin_account

#' Returns the membership details for specified member accounts for a
#' behavior graph
#'
#' @description
#' Returns the membership details for specified member accounts for a behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_get_members/](https://www.paws-r-sdk.com/docs/detective_get_members/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph for which to request the member details.
#' @param AccountIds &#91;required&#93; The list of Amazon Web Services account identifiers for the member
#' account for which to return member details. You can request details for
#' up to 50 member accounts at a time.
#' 
#' You cannot use [`get_members`][detective_get_members] to retrieve
#' information about member accounts that were removed from the behavior
#' graph.
#'
#' @keywords internal
#'
#' @rdname detective_get_members
detective_get_members <- function(GraphArn, AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/graph/members/get",
    paginator = list()
  )
  input <- .detective$get_members_input(GraphArn = GraphArn, AccountIds = AccountIds)
  output <- .detective$get_members_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$get_members <- detective_get_members

#' Lists data source packages in the behavior graph
#'
#' @description
#' Lists data source packages in the behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_datasource_packages/](https://www.paws-r-sdk.com/docs/detective_list_datasource_packages/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph.
#' @param NextToken For requests to get the next page of results, the pagination token that
#' was returned with the previous set of results. The initial request does
#' not include a pagination token.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname detective_list_datasource_packages
detective_list_datasource_packages <- function(GraphArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatasourcePackages",
    http_method = "POST",
    http_path = "/graph/datasources/list",
    paginator = list()
  )
  input <- .detective$list_datasource_packages_input(GraphArn = GraphArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .detective$list_datasource_packages_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_datasource_packages <- detective_list_datasource_packages

#' Returns the list of behavior graphs that the calling account is an
#' administrator account of
#'
#' @description
#' Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_graphs/](https://www.paws-r-sdk.com/docs/detective_list_graphs/) for full documentation.
#'
#' @param NextToken For requests to get the next page of results, the pagination token that
#' was returned with the previous set of results. The initial request does
#' not include a pagination token.
#' @param MaxResults The maximum number of graphs to return at a time. The total must be less
#' than the overall limit on the number of results to return, which is
#' currently 200.
#'
#' @keywords internal
#'
#' @rdname detective_list_graphs
detective_list_graphs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGraphs",
    http_method = "POST",
    http_path = "/graphs/list",
    paginator = list()
  )
  input <- .detective$list_graphs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .detective$list_graphs_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_graphs <- detective_list_graphs

#' Retrieves the list of open and accepted behavior graph invitations for
#' the member account
#'
#' @description
#' Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by an invited member account.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_invitations/](https://www.paws-r-sdk.com/docs/detective_list_invitations/) for full documentation.
#'
#' @param NextToken For requests to retrieve the next page of results, the pagination token
#' that was returned with the previous page of results. The initial request
#' does not include a pagination token.
#' @param MaxResults The maximum number of behavior graph invitations to return in the
#' response. The total must be less than the overall limit on the number of
#' results to return, which is currently 200.
#'
#' @keywords internal
#'
#' @rdname detective_list_invitations
detective_list_invitations <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "POST",
    http_path = "/invitations/list",
    paginator = list()
  )
  input <- .detective$list_invitations_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .detective$list_invitations_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_invitations <- detective_list_invitations

#' Retrieves the list of member accounts for a behavior graph
#'
#' @description
#' Retrieves the list of member accounts for a behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_members/](https://www.paws-r-sdk.com/docs/detective_list_members/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph for which to retrieve the list of member
#' accounts.
#' @param NextToken For requests to retrieve the next page of member account results, the
#' pagination token that was returned with the previous page of results.
#' The initial request does not include a pagination token.
#' @param MaxResults The maximum number of member accounts to include in the response. The
#' total must be less than the overall limit on the number of results to
#' return, which is currently 200.
#'
#' @keywords internal
#'
#' @rdname detective_list_members
detective_list_members <- function(GraphArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "POST",
    http_path = "/graph/members/list",
    paginator = list()
  )
  input <- .detective$list_members_input(GraphArn = GraphArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .detective$list_members_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_members <- detective_list_members

#' Returns information about the Detective administrator account for an
#' organization
#'
#' @description
#' Returns information about the Detective administrator account for an organization. Can only be called by the organization management account.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_organization_admin_accounts/](https://www.paws-r-sdk.com/docs/detective_list_organization_admin_accounts/) for full documentation.
#'
#' @param NextToken For requests to get the next page of results, the pagination token that
#' was returned with the previous set of results. The initial request does
#' not include a pagination token.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname detective_list_organization_admin_accounts
detective_list_organization_admin_accounts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "POST",
    http_path = "/orgs/adminAccountslist",
    paginator = list()
  )
  input <- .detective$list_organization_admin_accounts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .detective$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_organization_admin_accounts <- detective_list_organization_admin_accounts

#' Returns the tag values that are assigned to a behavior graph
#'
#' @description
#' Returns the tag values that are assigned to a behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/detective_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the behavior graph for which to retrieve the tag values.
#'
#' @keywords internal
#'
#' @rdname detective_list_tags_for_resource
detective_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .detective$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .detective$list_tags_for_resource_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$list_tags_for_resource <- detective_list_tags_for_resource

#' Rejects an invitation to contribute the account data to a behavior graph
#'
#' @description
#' Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by an invited member account that has the `INVITED` status.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_reject_invitation/](https://www.paws-r-sdk.com/docs/detective_reject_invitation/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph to reject the invitation to.
#' 
#' The member account's current member status in the behavior graph must be
#' `INVITED`.
#'
#' @keywords internal
#'
#' @rdname detective_reject_invitation
detective_reject_invitation <- function(GraphArn) {
  op <- new_operation(
    name = "RejectInvitation",
    http_method = "POST",
    http_path = "/invitation/removal",
    paginator = list()
  )
  input <- .detective$reject_invitation_input(GraphArn = GraphArn)
  output <- .detective$reject_invitation_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$reject_invitation <- detective_reject_invitation

#' Sends a request to enable data ingest for a member account that has a
#' status of ACCEPTED_BUT_DISABLED
#'
#' @description
#' Sends a request to enable data ingest for a member account that has a status of `ACCEPTED_BUT_DISABLED`.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_start_monitoring_member/](https://www.paws-r-sdk.com/docs/detective_start_monitoring_member/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph.
#' @param AccountId &#91;required&#93; The account ID of the member account to try to enable.
#' 
#' The account must be an invited member account with a status of
#' `ACCEPTED_BUT_DISABLED`.
#'
#' @keywords internal
#'
#' @rdname detective_start_monitoring_member
detective_start_monitoring_member <- function(GraphArn, AccountId) {
  op <- new_operation(
    name = "StartMonitoringMember",
    http_method = "POST",
    http_path = "/graph/member/monitoringstate",
    paginator = list()
  )
  input <- .detective$start_monitoring_member_input(GraphArn = GraphArn, AccountId = AccountId)
  output <- .detective$start_monitoring_member_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$start_monitoring_member <- detective_start_monitoring_member

#' Applies tag values to a behavior graph
#'
#' @description
#' Applies tag values to a behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_tag_resource/](https://www.paws-r-sdk.com/docs/detective_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the behavior graph to assign the tags to.
#' @param Tags &#91;required&#93; The tags to assign to the behavior graph. You can add up to 50 tags. For
#' each tag, you provide the tag key and the tag value. Each tag key can
#' contain up to 128 characters. Each tag value can contain up to 256
#' characters.
#'
#' @keywords internal
#'
#' @rdname detective_tag_resource
detective_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .detective$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .detective$tag_resource_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$tag_resource <- detective_tag_resource

#' Removes tags from a behavior graph
#'
#' @description
#' Removes tags from a behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_untag_resource/](https://www.paws-r-sdk.com/docs/detective_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the behavior graph to remove the tags from.
#' @param TagKeys &#91;required&#93; The tag keys of the tags to remove from the behavior graph. You can
#' remove up to 50 tags at a time.
#'
#' @keywords internal
#'
#' @rdname detective_untag_resource
detective_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .detective$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .detective$untag_resource_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$untag_resource <- detective_untag_resource

#' Starts a data source packages for the behavior graph
#'
#' @description
#' Starts a data source packages for the behavior graph.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_update_datasource_packages/](https://www.paws-r-sdk.com/docs/detective_update_datasource_packages/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the behavior graph.
#' @param DatasourcePackages &#91;required&#93; The data source package start for the behavior graph.
#'
#' @keywords internal
#'
#' @rdname detective_update_datasource_packages
detective_update_datasource_packages <- function(GraphArn, DatasourcePackages) {
  op <- new_operation(
    name = "UpdateDatasourcePackages",
    http_method = "POST",
    http_path = "/graph/datasources/update",
    paginator = list()
  )
  input <- .detective$update_datasource_packages_input(GraphArn = GraphArn, DatasourcePackages = DatasourcePackages)
  output <- .detective$update_datasource_packages_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$update_datasource_packages <- detective_update_datasource_packages

#' Updates the configuration for the Organizations integration in the
#' current Region
#'
#' @description
#' Updates the configuration for the Organizations integration in the current Region. Can only be called by the Detective administrator account for the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/detective_update_organization_configuration/](https://www.paws-r-sdk.com/docs/detective_update_organization_configuration/) for full documentation.
#'
#' @param GraphArn &#91;required&#93; The ARN of the organization behavior graph.
#' @param AutoEnable Indicates whether to automatically enable new organization accounts as
#' member accounts in the organization behavior graph.
#'
#' @keywords internal
#'
#' @rdname detective_update_organization_configuration
detective_update_organization_configuration <- function(GraphArn, AutoEnable = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/orgs/updateOrganizationConfiguration",
    paginator = list()
  )
  input <- .detective$update_organization_configuration_input(GraphArn = GraphArn, AutoEnable = AutoEnable)
  output <- .detective$update_organization_configuration_output()
  config <- get_config()
  svc <- .detective$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.detective$operations$update_organization_configuration <- detective_update_organization_configuration
