# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Resource Access Manager
#'
#' @description
#' This is the *Resource Access Manager API Reference*. This documentation
#' provides descriptions and syntax for each of the actions and data types
#' in RAM. RAM is a service that helps you securely share your Amazon Web
#' Services resources to other Amazon Web Services accounts. If you use
#' Organizations to manage your accounts, then you can share your resources
#' with your entire organization or to organizational units (OUs). For
#' supported resource types, you can also share resources with individual
#' Identity and Access Management (IAM) roles and users.
#' 
#' To learn more about RAM, see the following resources:
#' 
#' -   [Resource Access Manager product page](https://aws.amazon.com/ram/)
#' 
#' -   [Resource Access Manager User
#'     Guide](https://docs.aws.amazon.com/ram/latest/userguide/)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ram(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ram()
#' svc$accept_resource_share_invitation(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ram_accept_resource_share_invitation]{accept_resource_share_invitation} \tab Accepts an invitation to a resource share from another Amazon Web Services account\cr
#'  \link[=ram_associate_resource_share]{associate_resource_share} \tab Adds the specified list of principals and list of resources to a resource share\cr
#'  \link[=ram_associate_resource_share_permission]{associate_resource_share_permission} \tab Adds or replaces the RAM permission for a resource type included in a resource share\cr
#'  \link[=ram_create_permission]{create_permission} \tab Creates a customer managed permission for a specified resource type that you can attach to resource shares\cr
#'  \link[=ram_create_permission_version]{create_permission_version} \tab Creates a new version of the specified customer managed permission\cr
#'  \link[=ram_create_resource_share]{create_resource_share} \tab Creates a resource share\cr
#'  \link[=ram_delete_permission]{delete_permission} \tab Deletes the specified customer managed permission in the Amazon Web Services Region in which you call this operation\cr
#'  \link[=ram_delete_permission_version]{delete_permission_version} \tab Deletes one version of a customer managed permission\cr
#'  \link[=ram_delete_resource_share]{delete_resource_share} \tab Deletes the specified resource share\cr
#'  \link[=ram_disassociate_resource_share]{disassociate_resource_share} \tab Removes the specified principals or resources from participating in the specified resource share\cr
#'  \link[=ram_disassociate_resource_share_permission]{disassociate_resource_share_permission} \tab Removes a managed permission from a resource share\cr
#'  \link[=ram_enable_sharing_with_aws_organization]{enable_sharing_with_aws_organization} \tab Enables resource sharing within your organization in Organizations\cr
#'  \link[=ram_get_permission]{get_permission} \tab Retrieves the contents of a managed permission in JSON format\cr
#'  \link[=ram_get_resource_policies]{get_resource_policies} \tab Retrieves the resource policies for the specified resources that you own and have shared\cr
#'  \link[=ram_get_resource_share_associations]{get_resource_share_associations} \tab Retrieves the lists of resources and principals that associated for resource shares that you own\cr
#'  \link[=ram_get_resource_share_invitations]{get_resource_share_invitations} \tab Retrieves details about invitations that you have received for resource shares\cr
#'  \link[=ram_get_resource_shares]{get_resource_shares} \tab Retrieves details about the resource shares that you own or that are shared with you\cr
#'  \link[=ram_list_pending_invitation_resources]{list_pending_invitation_resources} \tab Lists the resources in a resource share that is shared with you but for which the invitation is still PENDING\cr
#'  \link[=ram_list_permission_associations]{list_permission_associations} \tab Lists information about the managed permission and its associations to any resource shares that use this managed permission\cr
#'  \link[=ram_list_permissions]{list_permissions} \tab Retrieves a list of available RAM permissions that you can use for the supported resource types\cr
#'  \link[=ram_list_permission_versions]{list_permission_versions} \tab Lists the available versions of the specified RAM permission\cr
#'  \link[=ram_list_principals]{list_principals} \tab Lists the principals that you are sharing resources with or that are sharing resources with you\cr
#'  \link[=ram_list_replace_permission_associations_work]{list_replace_permission_associations_work} \tab Retrieves the current status of the asynchronous tasks performed by RAM when you perform the ReplacePermissionAssociationsWork operation\cr
#'  \link[=ram_list_resources]{list_resources} \tab Lists the resources that you added to a resource share or the resources that are shared with you\cr
#'  \link[=ram_list_resource_share_permissions]{list_resource_share_permissions} \tab Lists the RAM permissions that are associated with a resource share\cr
#'  \link[=ram_list_resource_types]{list_resource_types} \tab Lists the resource types that can be shared by RAM\cr
#'  \link[=ram_promote_permission_created_from_policy]{promote_permission_created_from_policy} \tab When you attach a resource-based policy to a resource, RAM automatically creates a resource share of featureSet=CREATED_FROM_POLICY with a managed permission that has the same IAM permissions as the original resource-based policy\cr
#'  \link[=ram_promote_resource_share_created_from_policy]{promote_resource_share_created_from_policy} \tab When you attach a resource-based policy to a resource, RAM automatically creates a resource share of featureSet=CREATED_FROM_POLICY with a managed permission that has the same IAM permissions as the original resource-based policy\cr
#'  \link[=ram_reject_resource_share_invitation]{reject_resource_share_invitation} \tab Rejects an invitation to a resource share from another Amazon Web Services account\cr
#'  \link[=ram_replace_permission_associations]{replace_permission_associations} \tab Updates all resource shares that use a managed permission to a different managed permission\cr
#'  \link[=ram_set_default_permission_version]{set_default_permission_version} \tab Designates the specified version number as the default version for the specified customer managed permission\cr
#'  \link[=ram_tag_resource]{tag_resource} \tab Adds the specified tag keys and values to a resource share or managed permission\cr
#'  \link[=ram_untag_resource]{untag_resource} \tab Removes the specified tag key and value pairs from the specified resource share or managed permission\cr
#'  \link[=ram_update_resource_share]{update_resource_share} \tab Modifies some of the properties of the specified resource share
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ram
#' @export
ram <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ram$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ram <- list()

.ram$operations <- list()

.ram$metadata <- list(
  service_name = "ram",
  endpoints = list("*" = list(endpoint = "ram.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ram.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "ram.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ram.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "RAM",
  api_version = "2018-01-04",
  signing_name = "ram",
  json_version = "1.1",
  target_prefix = ""
)

.ram$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.ram$metadata, handlers, config)
}
