% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_upgrade_applied_schema}
\alias{clouddirectory_upgrade_applied_schema}
\title{Upgrades a single directory in-place using the PublishedSchemaArn with
schema updates found in MinorVersion}
\usage{
clouddirectory_upgrade_applied_schema(
  PublishedSchemaArn,
  DirectoryArn,
  DryRun = NULL
)
}
\arguments{
\item{PublishedSchemaArn}{[required] The revision of the published schema to upgrade the directory to.}

\item{DirectoryArn}{[required] The ARN for the directory to which the upgraded schema will be applied.}

\item{DryRun}{Used for testing whether the major version schemas are backward
compatible or not. If schema compatibility fails, an exception would be
thrown else the call would succeed but no changes will be saved. This
parameter is optional.}
}
\description{
Upgrades a single directory in-place using the \code{PublishedSchemaArn} with schema updates found in \code{MinorVersion}. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.

See \url{https://www.paws-r-sdk.com/docs/clouddirectory_upgrade_applied_schema/} for full documentation.
}
\keyword{internal}
