% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_get_finding_history}
\alias{securityhub_get_finding_history}
\title{Returns history for a Security Hub finding in the last 90 days}
\usage{
securityhub_get_finding_history(
  FindingIdentifier,
  StartTime = NULL,
  EndTime = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{FindingIdentifier}{[required]}

\item{StartTime}{A timestamp that indicates the start time of the requested finding
history.

If you provide values for both \code{StartTime} and \code{EndTime}, Security Hub
returns finding history for the specified time period. If you provide a
value for \code{StartTime} but not for \code{EndTime}, Security Hub returns
finding history from the \code{StartTime} to the time at which the API is
called. If you provide a value for \code{EndTime} but not for \code{StartTime},
Security Hub returns finding history from the
\href{https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt}{CreatedAt}
timestamp of the finding to the \code{EndTime}. If you provide neither
\code{StartTime} nor \code{EndTime}, Security Hub returns finding history from the
CreatedAt timestamp of the finding to the time at which the API is
called. In all of these scenarios, the response is limited to 100
results, and the maximum time period is limited to 90 days.

This field accepts only the specified formats. Timestamps can end with
\code{Z} or \verb{("+" / "-") time-hour [":" time-minute]}. The time-secfrac after
seconds is limited to a maximum of 9 digits. The offset is bounded by
+/-18:00. Here are valid timestamp formats with examples:
\itemize{
\item \code{YYYY-MM-DDTHH:MM:SSZ} (for example, \verb{2019-01-31T23:00:00Z})
\item \code{YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ} (for example,
\verb{2019-01-31T23:00:00.123456789Z})
\item \code{YYYY-MM-DDTHH:MM:SS+HH:MM} (for example,
\verb{2024-01-04T15:25:10+17:59})
\item \code{YYYY-MM-DDTHH:MM:SS-HHMM} (for example, \verb{2024-01-04T15:25:10-1759})
\item \code{YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM} (for example,
\verb{2024-01-04T15:25:10.123456789+17:59})
}}

\item{EndTime}{An ISO 8601-formatted timestamp that indicates the end time of the
requested finding history.

If you provide values for both \code{StartTime} and \code{EndTime}, Security Hub
returns finding history for the specified time period. If you provide a
value for \code{StartTime} but not for \code{EndTime}, Security Hub returns
finding history from the \code{StartTime} to the time at which the API is
called. If you provide a value for \code{EndTime} but not for \code{StartTime},
Security Hub returns finding history from the
\href{https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt}{CreatedAt}
timestamp of the finding to the \code{EndTime}. If you provide neither
\code{StartTime} nor \code{EndTime}, Security Hub returns finding history from the
CreatedAt timestamp of the finding to the time at which the API is
called. In all of these scenarios, the response is limited to 100
results, and the maximum time period is limited to 90 days.

This field accepts only the specified formats. Timestamps can end with
\code{Z} or \verb{("+" / "-") time-hour [":" time-minute]}. The time-secfrac after
seconds is limited to a maximum of 9 digits. The offset is bounded by
+/-18:00. Here are valid timestamp formats with examples:
\itemize{
\item \code{YYYY-MM-DDTHH:MM:SSZ} (for example, \verb{2019-01-31T23:00:00Z})
\item \code{YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ} (for example,
\verb{2019-01-31T23:00:00.123456789Z})
\item \code{YYYY-MM-DDTHH:MM:SS+HH:MM} (for example,
\verb{2024-01-04T15:25:10+17:59})
\item \code{YYYY-MM-DDTHH:MM:SS-HHMM} (for example, \verb{2024-01-04T15:25:10-1759})
\item \code{YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM} (for example,
\verb{2024-01-04T15:25:10.123456789+17:59})
}}

\item{NextToken}{A token for pagination purposes. Provide \code{NULL} as the initial value. In
subsequent requests, provide the token included in the response to get
up to an additional 100 results of finding history. If you don’t provide
\code{NextToken}, Security Hub returns up to 100 results of finding history
for each request.}

\item{MaxResults}{The maximum number of results to be returned. If you don’t provide it,
Security Hub returns up to 100 results of finding history.}
}
\description{
Returns history for a Security Hub finding in the last 90 days. The history includes changes made to any fields in the Amazon Web Services Security Finding Format (ASFF).

See \url{https://www.paws-r-sdk.com/docs/securityhub_get_finding_history/} for full documentation.
}
\keyword{internal}
