% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_account_aliases}
\alias{iam_list_account_aliases}
\title{Lists the account alias associated with the Amazon Web Services account
(Note: you can have only one)}
\usage{
iam_list_account_aliases(Marker = NULL, MaxItems = NULL)
}
\arguments{
\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For information about using an Amazon Web Services account alias, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/account-alias-create.html}{Creating, deleting, and listing an Amazon Web Services account alias} in the \emph{Amazon Web Services Sign-In User Guide}.

See \url{https://www.paws-r-sdk.com/docs/iam_list_account_aliases/} for full documentation.
}
\keyword{internal}
