% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_put_managed_rule_set_versions}
\alias{wafv2_put_managed_rule_set_versions}
\title{Defines the versions of your managed rule set that you are offering to
the customers}
\usage{
wafv2_put_managed_rule_set_versions(
  Name,
  Scope,
  Id,
  LockToken,
  RecommendedVersion = NULL,
  VersionsToPublish = NULL
)
}
\arguments{
\item{Name}{[required] The name of the managed rule set. You use this, along with the rule set
ID, to identify the rule set.

This name is assigned to the corresponding managed rule group, which
your customers can access and use.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{Id}{[required] A unique identifier for the managed rule set. The ID is returned in the
responses to commands like \code{list}. You provide it to operations like
\code{get} and \code{update}.}

\item{LockToken}{[required] A token used for optimistic locking. WAF returns a token to your \code{get}
and \code{list} requests, to mark the state of the entity at the time of the
request. To make changes to the entity associated with the token, you
provide the token to operations like \code{update} and \code{delete}. WAF uses the
token to ensure that no changes have been made to the entity since you
last retrieved it. If a change has been made, the update fails with a
\code{WAFOptimisticLockException}. If this happens, perform another \code{get},
and use the new token returned by that operation.}

\item{RecommendedVersion}{The version of the named managed rule group that you'd like your
customers to choose, from among your version offerings.}

\item{VersionsToPublish}{The versions of the named managed rule group that you want to offer to
your customers.}
}
\description{
Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.

See \url{https://www.paws-r-sdk.com/docs/wafv2_put_managed_rule_set_versions/} for full documentation.
}
\keyword{internal}
