% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_delete_tape}
\alias{storagegateway_delete_tape}
\title{Deletes the specified virtual tape}
\usage{
storagegateway_delete_tape(GatewayARN, TapeARN)
}
\arguments{
\item{GatewayARN}{[required] The unique Amazon Resource Name (ARN) of the gateway that the virtual
tape to delete is associated with. Use the ListGateways operation to
return a list of gateways for your account and region.}

\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape to delete.}
}
\description{
Deletes the specified virtual tape. This operation is only supported in
the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$delete_tape(
  GatewayARN = "string",
  TapeARN = "string"
)
}
}

\examples{
# This example deletes the specified virtual tape.
\donttest{svc$delete_tape(
  GatewayARN = "arn:aws:storagegateway:us-east-1:204469490176:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"
)}

}
\keyword{internal}
