% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_backup}
\alias{fsx_create_backup}
\title{Creates a backup of an existing Amazon FSx file system}
\usage{
fsx_create_backup(FileSystemId, ClientRequestToken, Tags)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system to back up.}

\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent creation. This string is automatically filled on your
behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
SDK.}

\item{Tags}{(Optional) The tags to apply to the backup at backup creation. The key
value of the \code{Name} tag appears in the console as the backup name. If
you have set \code{CopyTagsToBackups} to true, and you specify one or more
tags using the \code{CreateBackup} action, no existing file system tags are
copied from the file system to the backup.}
}
\description{
Creates a backup of an existing Amazon FSx file system. Creating regular
backups for your file system is a best practice, enabling you to restore
a file system from a backup if an issue arises with the original file
system.

For Amazon FSx for Lustre file systems, you can create a backup only for
file systems with the following configuration:
\itemize{
\item a Persistent deployment type
\item is \emph{not} linked to a data respository.
}

For more information about backing up Amazon FSx for Lustre file
systems, see \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html}{Working with FSx for Lustre backups}.

For more information about backing up Amazon FSx for Windows file
systems, see \href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html}{Working with FSx for Windows backups}.

If a backup with the specified client request token exists, and the
parameters match, this operation returns the description of the existing
backup. If a backup specified client request token exists, and the
parameters don't match, this operation returns
\code{IncompatibleParameterError}. If a backup with the specified client
request token doesn't exist, \code{CreateBackup} does the following:
\itemize{
\item Creates a new Amazon FSx backup with an assigned ID, and an initial
lifecycle state of \code{CREATING}.
\item Returns the description of the backup.
}

By using the idempotent operation, you can retry a \code{CreateBackup}
operation without the risk of creating an extra backup. This approach
can be useful when an initial call fails in a way that makes it unclear
whether a backup was created. If you use the same client request token
and the initial call created a backup, the operation returns a
successful result because all the parameters are the same.

The \code{CreateBackup} operation returns while the backup's lifecycle state
is still \code{CREATING}. You can check the backup creation status by calling
the DescribeBackups operation, which returns the backup state along with
other information.
}
\section{Request syntax}{
\preformatted{svc$create_backup(
  FileSystemId = "string",
  ClientRequestToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This operation creates a new backup.
svc$create_backup(
  FileSystemId = "fs-0498eed5fe91001ec",
  Tags = list(
    list(
      Key = "Name",
      Value = "MyBackup"
    )
  )
)
}

}
\keyword{internal}
