% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_lifecycle_configuration}
\alias{s3_get_bucket_lifecycle_configuration}
\title{Bucket lifecycle configuration now supports specifying a lifecycle rule
using an object key name prefix, one or more object tags, or a
combination of both}
\usage{
s3_get_bucket_lifecycle_configuration(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the lifecycle information.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Bucket lifecycle configuration now supports specifying a lifecycle rule
using an object key name prefix, one or more object tags, or a
combination of both. Accordingly, this section describes the latest API.
The response describes the new filter element that you can use to
specify a filter to select a subset of objects to which the rule
applies. If you are using a previous version of the lifecycle
configuration, it still works. For the earlier API description, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html}{GetBucketLifecycle}.

Returns the lifecycle configuration information set on the bucket. For
information about lifecycle configuration, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html}{Object Lifecycle Management}.

To use this operation, you must have permission to perform the
\code{s3:GetLifecycleConfiguration} action. The bucket owner has this
permission, by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

\code{GetBucketLifecycleConfiguration} has the following special error:
\itemize{
\item Error code: \code{NoSuchLifecycleConfiguration}
\itemize{
\item Description: The lifecycle configuration does not exist.
\item HTTP Status Code: 404 Not Found
\item SOAP Fault Code Prefix: Client
}
}

The following operations are related to
\code{GetBucketLifecycleConfiguration}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html}{GetBucketLifecycle}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html}{PutBucketLifecycle}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html}{DeleteBucketLifecycle}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_lifecycle_configuration(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example retrieves lifecycle configuration on set on a
# bucket.
svc$get_bucket_lifecycle_configuration(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
