% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object_legal_hold}
\alias{s3_get_object_legal_hold}
\title{Gets an object's current Legal Hold status}
\usage{
s3_get_object_legal_hold(Bucket, Key, VersionId, RequestPayer,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object whose Legal Hold status you want
to retrieve.

When using this API with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this operation with an access point through the AWS SDKs, you
provide the access point ARN in place of the bucket name. For more
information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html}{Using Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{Key}{[required] The key name for the object whose Legal Hold status you want to
retrieve.}

\item{VersionId}{The version ID of the object whose Legal Hold status you want to
retrieve.}

\item{RequestPayer}{}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Gets an object's current Legal Hold status. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html}{Locking Objects}.

This action is not supported by Amazon S3 on Outposts.
}
\section{Request syntax}{
\preformatted{svc$get_object_legal_hold(
  Bucket = "string",
  Key = "string",
  VersionId = "string",
  RequestPayer = "requester",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
