% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_regional_buckets}
\alias{s3control_list_regional_buckets}
\title{Returns a list of all Outposts buckets in an Outpost that are owned by
the authenticated sender of the request}
\usage{
s3control_list_regional_buckets(AccountId, NextToken, MaxResults,
  OutpostId)
}
\arguments{
\item{AccountId}{[required] The AWS account ID of the Outposts bucket.}

\item{NextToken}{}

\item{MaxResults}{}

\item{OutpostId}{The ID of the AWS Outposts.

This is required by Amazon S3 on Outposts buckets.}
}
\description{
Returns a list of all Outposts buckets in an Outpost that are owned by
the authenticated sender of the request. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon Simple Storage Service Developer Guide}.

For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and \code{x-amz-outpost-id} in
your request, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples}{Examples}
section.
}
\section{Request syntax}{
\preformatted{svc$list_regional_buckets(
  AccountId = "string",
  NextToken = "string",
  MaxResults = 123,
  OutpostId = "string"
)
}
}

\keyword{internal}
