% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_tag_resource}
\alias{fsx_tag_resource}
\title{Tags an Amazon FSx resource}
\usage{
fsx_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the Amazon FSx resource that you want
to tag.}

\item{Tags}{[required] A list of tags for the resource. If a tag with a given key already
exists, the value is replaced by the one specified in this parameter.}
}
\value{
An empty list.
}
\description{
Tags an Amazon FSx resource.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This operation tags an Amazon FSx resource.
svc$tag_resource(
  ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec",
  Tags = list(
    list(
      Key = "Name",
      Value = "MyFileSystem"
    )
  )
)
}

}
\keyword{internal}
