% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_cancel_retrieval}
\alias{storagegateway_cancel_retrieval}
\title{Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
a gateway after the retrieval process is initiated}
\usage{
storagegateway_cancel_retrieval(GatewayARN, TapeARN)
}
\arguments{
\item{GatewayARN}{[required]}

\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape you want to cancel
retrieval for.}
}
\value{
A list with the following syntax:\preformatted{list(
  TapeARN = "string"
)
}
}
\description{
Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
a gateway after the retrieval process is initiated. The virtual tape is
returned to the VTS. This operation is only supported in the tape
gateway type.
}
\section{Request syntax}{
\preformatted{svc$cancel_retrieval(
  GatewayARN = "string",
  TapeARN = "string"
)
}
}

\examples{
\dontrun{
# Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
# a gateway after the retrieval process is initiated.
svc$cancel_retrieval(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
)
}

}
\keyword{internal}
