% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_cors}
\alias{s3_put_bucket_cors}
\title{Sets the CORS configuration for a bucket}
\usage{
s3_put_bucket_cors(Bucket, CORSConfiguration, ContentMD5)
}
\arguments{
\item{Bucket}{[required]}

\item{CORSConfiguration}{[required]}

\item{ContentMD5}{}
}
\description{
Sets the CORS configuration for a bucket.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_cors(
  Bucket = "string",
  CORSConfiguration = list(
    CORSRules = list(
      list(
        AllowedHeaders = list(
          "string"
        ),
        AllowedMethods = list(
          "string"
        ),
        AllowedOrigins = list(
          "string"
        ),
        ExposeHeaders = list(
          "string"
        ),
        MaxAgeSeconds = 123
      )
    )
  ),
  ContentMD5 = "string"
)
}
}

\examples{
# The following example enables PUT, POST, and DELETE requests from
# www.example.com, and enables GET requests from any domain.
\donttest{svc$put_bucket_cors(
  Bucket = "",
  CORSConfiguration = list(
    CORSRules = list(
      list(
        AllowedHeaders = list(
          "*"
        ),
        AllowedMethods = list(
          "PUT",
          "POST",
          "DELETE"
        ),
        AllowedOrigins = list(
          "http://www.example.com"
        ),
        ExposeHeaders = list(
          "x-amz-server-side-encryption"
        ),
        MaxAgeSeconds = 3000L
      ),
      list(
        AllowedHeaders = list(
          "Authorization"
        ),
        AllowedMethods = list(
          "GET"
        ),
        AllowedOrigins = list(
          "*"
        ),
        MaxAgeSeconds = 3000L
      )
    )
  ),
  ContentMD5 = ""
)}

}
\keyword{internal}
