% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_create_tags}
\alias{efs_create_tags}
\title{Creates or overwrites tags associated with a file system}
\usage{
efs_create_tags(FileSystemId, Tags)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system whose tags you want to modify (String). This
operation modifies the tags only, not the file system.}

\item{Tags}{[required] An array of \code{Tag} objects to add. Each \code{Tag} object is a key-value pair.}
}
\description{
Creates or overwrites tags associated with a file system. Each tag is a
key-value pair. If a tag key specified in the request already exists on
the file system, this operation overwrites its value with the value
provided in the request. If you add the \code{Name} tag to your file system,
Amazon EFS returns it in the response to the DescribeFileSystems
operation.
}
\details{
This operation requires permission for the
\code{elasticfilesystem:CreateTags} action.
}
\section{Request syntax}{
\preformatted{svc$create_tags(
  FileSystemId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# This operation creates a new tag for an EFS file system.
\donttest{svc$create_tags(
  FileSystemId = "fs-01234567",
  Tags = list(
    list(
      Key = "Name",
      Value = "MyFileSystem"
    )
  )
)}

}
\keyword{internal}
