% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_replication}
\alias{s3_delete_bucket_replication}
\title{Deletes the replication configuration from the bucket}
\usage{
s3_delete_bucket_replication(Bucket)
}
\arguments{
\item{Bucket}{[required] The bucket name.}
}
\description{
Deletes the replication configuration from the bucket.
}
\details{
To use this operation, you must have permissions to perform the
\code{s3:PutReplicationConfiguration} action. The bucket owner has these
permissions by default and can grant it to others. For more information
about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

It can take a while for the deletion of a replication configuration to
fully propagate.

For information about replication configuration, see Replication in the
\emph{Amazon S3 Developer Guide}.

The following operations are related to \code{DeleteBucketReplication}:
\itemize{
\item PutBucketReplication
\item GetBucketReplication
}
}
\section{Request syntax}{
\preformatted{svc$delete_bucket_replication(
  Bucket = "string"
)
}
}

\examples{
# The following example deletes replication configuration set on bucket.
\dontrun{svc$delete_bucket_replication(
  Bucket = "example"
)}

}
\keyword{internal}
