% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_shutdown_gateway}
\alias{storagegateway_shutdown_gateway}
\title{Shuts down a gateway}
\usage{
storagegateway_shutdown_gateway(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Shuts down a gateway. To specify which gateway to shut down, use the
Amazon Resource Name (ARN) of the gateway in the body of your request.
}
\details{
The operation shuts down the gateway service component running in the
gateway\'s virtual machine (VM) and not the host VM.

If you want to shut down the VM, it is recommended that you first shut
down the gateway component in the VM to avoid unpredictable conditions.

After the gateway is shutdown, you cannot call any other API except
StartGateway, DescribeGatewayInformation, and ListGateways. For more
information, see ActivateGateway. Your applications cannot read from or
write to the gateway\'s storage volumes, and there are no snapshots
taken.

When you make a shutdown request, you will get a \verb{200 OK} success
response immediately. However, it might take some time for the gateway
to shut down. You can call the DescribeGatewayInformation API to check
the status. For more information, see ActivateGateway.

If do not intend to use the gateway again, you must delete the gateway
(using DeleteGateway) to no longer pay software charges associated with
the gateway.
}
\section{Request syntax}{
\preformatted{svc$shutdown_gateway(
  GatewayARN = "string"
)
}
}

\examples{
# This operation shuts down the gateway service component running in the
# storage gateway's virtual machine (VM) and not the VM.
\dontrun{svc$shutdown_gateway(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
