% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_tape_recovery_points}
\alias{storagegateway_describe_tape_recovery_points}
\title{Returns a list of virtual tape recovery points that are available for
the specified tape gateway}
\usage{
storagegateway_describe_tape_recovery_points(GatewayARN, Marker, Limit)
}
\arguments{
\item{GatewayARN}{[required]}

\item{Marker}{An opaque string that indicates the position at which to begin
describing the virtual tape recovery points.}

\item{Limit}{Specifies that the number of virtual tape recovery points that are
described be limited to the specified number.}
}
\description{
Returns a list of virtual tape recovery points that are available for
the specified tape gateway.
}
\details{
A recovery point is a point-in-time view of a virtual tape at which all
the data on the virtual tape is consistent. If your gateway crashes,
virtual tapes that have recovery points can be recovered to a new
gateway. This operation is only supported in the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$describe_tape_recovery_points(
  GatewayARN = "string",
  Marker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# Returns a list of virtual tape recovery points that are available for
# the specified gateway-VTL.
svc$describe_tape_recovery_points(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
  Limit = 1L,
  Marker = "1"
)
}

}
\keyword{internal}
