% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_delete_file_system}
\alias{fsx_delete_file_system}
\title{Deletes a file system}
\usage{
fsx_delete_file_system(
  FileSystemId,
  ClientRequestToken = NULL,
  WindowsConfiguration = NULL,
  LustreConfiguration = NULL,
  OpenZFSConfiguration = NULL
)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system that you want to delete.}

\item{ClientRequestToken}{A string of up to 64 ASCII characters that Amazon FSx uses to ensure
idempotent deletion. This token is automatically filled on your behalf
when using the Command Line Interface (CLI) or an Amazon Web Services
SDK.}

\item{WindowsConfiguration}{}

\item{LustreConfiguration}{}

\item{OpenZFSConfiguration}{The configuration object for the OpenZFS file system used in the
\code{\link[=fsx_delete_file_system]{delete_file_system}} operation.}
}
\description{
Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.

See \url{https://paws-r.github.io/docs/fsx/delete_file_system.html} for full documentation.
}
\keyword{internal}
