# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Recycle Bin
#'
#' @description
#' This is the *Recycle Bin API Reference*. This documentation provides
#' descriptions and syntax for each of the actions and data types in
#' Recycle Bin.
#' 
#' Recycle Bin is a resource recovery feature that enables you to restore
#' accidentally deleted snapshots and EBS-backed AMIs. When using Recycle
#' Bin, if your resources are deleted, they are retained in the Recycle Bin
#' for a time period that you specify.
#' 
#' You can restore a resource from the Recycle Bin at any time before its
#' retention period expires. After you restore a resource from the Recycle
#' Bin, the resource is removed from the Recycle Bin, and you can then use
#' it in the same way you use any other resource of that type in your
#' account. If the retention period expires and the resource is not
#' restored, the resource is permanently deleted from the Recycle Bin and
#' is no longer available for recovery. For more information about Recycle
#' Bin, see [Recycle
#' Bin](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- recyclebin(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- recyclebin()
#' svc$create_rule(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=recyclebin_create_rule]{create_rule} \tab Creates a Recycle Bin retention rule\cr
#'  \link[=recyclebin_delete_rule]{delete_rule} \tab Deletes a Recycle Bin retention rule\cr
#'  \link[=recyclebin_get_rule]{get_rule} \tab Gets information about a Recycle Bin retention rule\cr
#'  \link[=recyclebin_list_rules]{list_rules} \tab Lists the Recycle Bin retention rules in the Region\cr
#'  \link[=recyclebin_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags assigned to a retention rule\cr
#'  \link[=recyclebin_lock_rule]{lock_rule} \tab Locks a retention rule\cr
#'  \link[=recyclebin_tag_resource]{tag_resource} \tab Assigns tags to the specified retention rule\cr
#'  \link[=recyclebin_unlock_rule]{unlock_rule} \tab Unlocks a retention rule\cr
#'  \link[=recyclebin_untag_resource]{untag_resource} \tab Unassigns a tag from a retention rule\cr
#'  \link[=recyclebin_update_rule]{update_rule} \tab Updates an existing Recycle Bin retention rule
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname recyclebin
#' @export
recyclebin <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .recyclebin$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.recyclebin <- list()

.recyclebin$operations <- list()

.recyclebin$metadata <- list(
  service_name = "recyclebin",
  endpoints = list("*" = list(endpoint = "rbin.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "rbin.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "rbin.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "rbin.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "rbin.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "rbin.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "rbin",
  api_version = "2021-06-15",
  signing_name = "rbin",
  json_version = "1.1",
  target_prefix = ""
)

.recyclebin$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.recyclebin$metadata, handlers, config)
}
