% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{personalizeruntime}
\alias{personalizeruntime}
\title{Amazon Personalize Runtime}
\usage{
personalizeruntime(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Personalize Runtime
}
\section{Service syntax}{
\preformatted{svc <- personalizeruntime(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=personalizeruntime_get_personalized_ranking]{get_personalized_ranking} \tab Re-ranks a list of recommended items for the given user\cr
\link[=personalizeruntime_get_recommendations]{get_recommendations} \tab Returns a list of recommended items
}
}

\examples{
\dontrun{
svc <- personalizeruntime()
svc$get_personalized_ranking(
  Foo = 123
)
}

}
