% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{dynamodbstreams}
\alias{dynamodbstreams}
\title{Amazon DynamoDB Streams}
\usage{
dynamodbstreams()
}
\description{
Amazon DynamoDB

Amazon DynamoDB Streams provides API actions for accessing streams and
processing stream records. To learn more about application development
with Streams, see \href{http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Streams.html}{Capturing Table Activity with DynamoDB Streams}
in the Amazon DynamoDB Developer Guide.
}
\section{Operations}{

\tabular{ll}{
\link[=dynamodbstreams_describe_stream]{describe_stream} \tab Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table\cr
\link[=dynamodbstreams_get_records]{get_records} \tab Retrieves the stream records from a given shard \cr
\link[=dynamodbstreams_get_shard_iterator]{get_shard_iterator} \tab Returns a shard iterator \cr
\link[=dynamodbstreams_list_streams]{list_streams} \tab Returns an array of stream ARNs associated with the current account and endpoint
}
}

\examples{
# The following example describes a stream with a given stream ARN.
\donttest{svc <- dynamodbstreams()
svc$describe_stream(
  StreamArn = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2015-05-20T20:51:1..."
)}

}
