% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{glacier}
\alias{glacier}
\title{Amazon Glacier}
\usage{
glacier()
}
\description{
Amazon S3 Glacier (Glacier) is a storage solution for "cold data."

Glacier is an extremely low-cost storage service that provides secure,
durable, and easy-to-use storage for data backup and archival. With
Glacier, customers can store their data cost effectively for months,
years, or decades. Glacier also enables customers to offload the
administrative burdens of operating and scaling storage to AWS, so they
don't have to worry about capacity planning, hardware provisioning,
data replication, hardware failure and recovery, or time-consuming
hardware migrations.

Glacier is a great storage choice when low storage cost is paramount and
your data is rarely retrieved. If your application requires fast or
frequent access to your data, consider using Amazon S3. For more
information, see \href{http://aws.amazon.com/s3/}{Amazon Simple Storage Service (Amazon S3)}.

You can store any kind of data in any format. There is no maximum limit
on the total amount of data you can store in Glacier.

If you are a first-time user of Glacier, we recommend that you begin by
reading the following sections in the \emph{Amazon S3 Glacier Developer
Guide}:
\itemize{
\item \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/introduction.html}{What is Amazon S3 Glacier} -
This section of the Developer Guide describes the underlying data
model, the operations it supports, and the AWS SDKs that you can use
to interact with the service.
\item \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/amazon-glacier-getting-started.html}{Getting Started with Amazon S3 Glacier} -
The Getting Started section walks you through the process of
creating a vault, uploading archives, creating jobs to download
archives, retrieving the job output, and deleting archives.
}
}
\section{Operations}{

\tabular{ll}{
\link[=glacier_abort_multipart_upload]{abort_multipart_upload} \tab This operation aborts a multipart upload identified by the upload ID \cr
\link[=glacier_abort_vault_lock]{abort_vault_lock} \tab This operation aborts the vault locking process if the vault lock is not in the Locked state \cr
\link[=glacier_add_tags_to_vault]{add_tags_to_vault} \tab This operation adds the specified tags to a vault \cr
\link[=glacier_complete_multipart_upload]{complete_multipart_upload} \tab You call this operation to inform Amazon S3 Glacier (Glacier) that all the archive parts have been uploaded and that Glacier can now assemble the archive from the uploaded parts \cr
\link[=glacier_complete_vault_lock]{complete_vault_lock} \tab This operation completes the vault locking process by transitioning the vault lock from the InProgress state to the Locked state, which causes the vault lock policy to become unchangeable \cr
\link[=glacier_create_vault]{create_vault} \tab This operation creates a new vault with the specified name \cr
\link[=glacier_delete_archive]{delete_archive} \tab This operation deletes an archive from a vault \cr
\link[=glacier_delete_vault]{delete_vault} \tab This operation deletes a vault \cr
\link[=glacier_delete_vault_access_policy]{delete_vault_access_policy} \tab This operation deletes the access policy associated with the specified vault \cr
\link[=glacier_delete_vault_notifications]{delete_vault_notifications} \tab This operation deletes the notification configuration set for a vault \cr
\link[=glacier_describe_job]{describe_job} \tab This operation returns information about a job you previously initiated, including the job initiation date, the user who initiated the job, the job status code/message and the Amazon SNS topic to notify after Amazon S3 Glacier (Glacier) completes the job\cr
\link[=glacier_describe_vault]{describe_vault} \tab This operation returns information about a vault, including the vault's Amazon Resource Name (ARN), the date the vault was created, the number of archives it contains, and the total size of all the archives in the vault \cr
\link[=glacier_get_data_retrieval_policy]{get_data_retrieval_policy} \tab This operation returns the current data retrieval policy for the account and region specified in the GET request \cr
\link[=glacier_get_job_output]{get_job_output} \tab This operation downloads the output of the job you initiated using InitiateJob \cr
\link[=glacier_get_vault_access_policy]{get_vault_access_policy} \tab This operation retrieves the access-policy subresource set on the vault; for more information on setting this subresource, see Set Vault Access Policy (PUT access-policy) \cr
\link[=glacier_get_vault_lock]{get_vault_lock} \tab This operation retrieves the following attributes from the lock-policy subresource set on the specified vault: - The vault lock policy set on the vault \cr
\link[=glacier_get_vault_notifications]{get_vault_notifications} \tab This operation retrieves the notification-configuration subresource of the specified vault \cr
\link[=glacier_initiate_job]{initiate_job} \tab This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault retrieval \cr
\link[=glacier_initiate_multipart_upload]{initiate_multipart_upload} \tab This operation initiates a multipart upload \cr
\link[=glacier_initiate_vault_lock]{initiate_vault_lock} \tab This operation initiates the vault locking process by doing the following: - Installing a vault lock policy on the specified vault \cr
\link[=glacier_list_jobs]{list_jobs} \tab This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished \cr
\link[=glacier_list_multipart_uploads]{list_multipart_uploads} \tab This operation lists in-progress multipart uploads for the specified vault \cr
\link[=glacier_list_parts]{list_parts} \tab This operation lists the parts of an archive that have been uploaded in a specific multipart upload \cr
\link[=glacier_list_provisioned_capacity]{list_provisioned_capacity} \tab This operation lists the provisioned capacity units for the specified AWS account \cr
\link[=glacier_list_tags_for_vault]{list_tags_for_vault} \tab This operation lists all the tags attached to a vault \cr
\link[=glacier_list_vaults]{list_vaults} \tab This operation lists all vaults owned by the calling user's account \cr
\link[=glacier_purchase_provisioned_capacity]{purchase_provisioned_capacity} \tab This operation purchases a provisioned capacity unit for an AWS account \cr
\link[=glacier_remove_tags_from_vault]{remove_tags_from_vault} \tab This operation removes one or more tags from the set of tags attached to a vault \cr
\link[=glacier_set_data_retrieval_policy]{set_data_retrieval_policy} \tab This operation sets and then enacts a data retrieval policy in the region specified in the PUT request \cr
\link[=glacier_set_vault_access_policy]{set_vault_access_policy} \tab This operation configures an access policy for a vault and will overwrite an existing policy \cr
\link[=glacier_set_vault_notifications]{set_vault_notifications} \tab This operation configures notifications that will be sent when specific events happen to a vault \cr
\link[=glacier_upload_archive]{upload_archive} \tab This operation adds an archive to a vault \cr
\link[=glacier_upload_multipart_part]{upload_multipart_part} \tab This operation uploads a part of an archive
}
}

\examples{
# The example deletes an in-progress multipart upload to a vault named
# my-vault:
\donttest{svc <- glacier()
svc$abort_multipart_upload(
  accountId = "-",
  uploadId = "19gaRezEXAMPLES6Ry5YYdqthHOC_kGRCT03L9yetr220UmPtBYKk-OssZtLqyFu7sY1_lR7vgFuJV...",
  vaultName = "my-vault"
)}

}
