% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{iamrolesanywhere}
\alias{iamrolesanywhere}
\title{IAM Roles Anywhere}
\usage{
iamrolesanywhere(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Identity and Access Management Roles Anywhere provides a secure way for
your workloads such as servers, containers, and applications that run
outside of Amazon Web Services to obtain temporary Amazon Web Services
credentials. Your workloads can use the same IAM policies and roles you
have for native Amazon Web Services applications to access Amazon Web
Services resources. Using IAM Roles Anywhere eliminates the need to
manage long-term credentials for workloads running outside of Amazon Web
Services.

To use IAM Roles Anywhere, your workloads must use X.509 certificates
issued by their certificate authority (CA). You register the CA with IAM
Roles Anywhere as a trust anchor to establish trust between your public
key infrastructure (PKI) and IAM Roles Anywhere. If you don't manage
your own PKI system, you can use Private Certificate Authority to create
a CA and then use that to establish trust with IAM Roles Anywhere.

This guide describes the IAM Roles Anywhere operations that you can call
programmatically. For more information about IAM Roles Anywhere, see the
\href{https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html}{IAM Roles Anywhere User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- iamrolesanywhere(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:iamrolesanywhere_create_profile]{create_profile} \tab Creates a profile, a list of the roles that Roles Anywhere service is trusted to assume\cr
\link[paws.security.identity:iamrolesanywhere_create_trust_anchor]{create_trust_anchor} \tab Creates a trust anchor to establish trust between IAM Roles Anywhere and your certificate authority (CA)\cr
\link[paws.security.identity:iamrolesanywhere_delete_crl]{delete_crl} \tab Deletes a certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_delete_profile]{delete_profile} \tab Deletes a profile\cr
\link[paws.security.identity:iamrolesanywhere_delete_trust_anchor]{delete_trust_anchor} \tab Deletes a trust anchor\cr
\link[paws.security.identity:iamrolesanywhere_disable_crl]{disable_crl} \tab Disables a certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_disable_profile]{disable_profile} \tab Disables a profile\cr
\link[paws.security.identity:iamrolesanywhere_disable_trust_anchor]{disable_trust_anchor} \tab Disables a trust anchor\cr
\link[paws.security.identity:iamrolesanywhere_enable_crl]{enable_crl} \tab Enables a certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_enable_profile]{enable_profile} \tab Enables temporary credential requests for a profile\cr
\link[paws.security.identity:iamrolesanywhere_enable_trust_anchor]{enable_trust_anchor} \tab Enables a trust anchor\cr
\link[paws.security.identity:iamrolesanywhere_get_crl]{get_crl} \tab Gets a certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_get_profile]{get_profile} \tab Gets a profile\cr
\link[paws.security.identity:iamrolesanywhere_get_subject]{get_subject} \tab Gets a subject, which associates a certificate identity with authentication attempts\cr
\link[paws.security.identity:iamrolesanywhere_get_trust_anchor]{get_trust_anchor} \tab Gets a trust anchor\cr
\link[paws.security.identity:iamrolesanywhere_import_crl]{import_crl} \tab Imports the certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_list_crls]{list_crls} \tab Lists all certificate revocation lists (CRL) in the authenticated account and Amazon Web Services Region\cr
\link[paws.security.identity:iamrolesanywhere_list_profiles]{list_profiles} \tab Lists all profiles in the authenticated account and Amazon Web Services Region\cr
\link[paws.security.identity:iamrolesanywhere_list_subjects]{list_subjects} \tab Lists the subjects in the authenticated account and Amazon Web Services Region\cr
\link[paws.security.identity:iamrolesanywhere_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags attached to the resource\cr
\link[paws.security.identity:iamrolesanywhere_list_trust_anchors]{list_trust_anchors} \tab Lists the trust anchors in the authenticated account and Amazon Web Services Region\cr
\link[paws.security.identity:iamrolesanywhere_put_notification_settings]{put_notification_settings} \tab Attaches a list of notification settings to a trust anchor\cr
\link[paws.security.identity:iamrolesanywhere_reset_notification_settings]{reset_notification_settings} \tab Resets the custom notification setting to IAM Roles Anywhere default setting\cr
\link[paws.security.identity:iamrolesanywhere_tag_resource]{tag_resource} \tab Attaches tags to a resource\cr
\link[paws.security.identity:iamrolesanywhere_untag_resource]{untag_resource} \tab Removes tags from the resource\cr
\link[paws.security.identity:iamrolesanywhere_update_crl]{update_crl} \tab Updates the certificate revocation list (CRL)\cr
\link[paws.security.identity:iamrolesanywhere_update_profile]{update_profile} \tab Updates a profile, a list of the roles that IAM Roles Anywhere service is trusted to assume\cr
\link[paws.security.identity:iamrolesanywhere_update_trust_anchor]{update_trust_anchor} \tab Updates a trust anchor
}
}

\examples{
\dontrun{
svc <- iamrolesanywhere()
svc$create_profile(
  Foo = 123
)
}

}
