% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ssooidc}
\alias{ssooidc}
\title{AWS SSO OIDC}
\usage{
ssooidc(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
AWS IAM Identity Center (successor to AWS Single Sign-On) OpenID Connect
(OIDC) is a web service that enables a client (such as AWS CLI or a
native application) to register with IAM Identity Center. The service
also enables the client to fetch the user’s access token upon successful
authentication and authorization with IAM Identity Center.

Although AWS Single Sign-On was renamed, the \code{sso} and \code{identitystore}
API namespaces will continue to retain their original name for backward
compatibility purposes. For more information, see \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed}{IAM Identity Center rename}.

\strong{Considerations for Using This Guide}

Before you begin using this guide, we recommend that you first review
the following important information about how the IAM Identity Center
OIDC service works.
\itemize{
\item The IAM Identity Center OIDC service currently implements only the
portions of the OAuth 2.0 Device Authorization Grant standard
(\href{https://datatracker.ietf.org/doc/html/rfc8628}{https://tools.ietf.org/html/rfc8628})
that are necessary to enable single sign-on authentication with the
AWS CLI. Support for other OIDC flows frequently needed for native
applications, such as Authorization Code Flow (+ PKCE), will be
addressed in future releases.
\item The service emits only OIDC access tokens, such that obtaining a new
token (For example, token refresh) requires explicit user
re-authentication.
\item The access tokens provided by this service grant access to all AWS
account entitlements assigned to an IAM Identity Center user, not
just a particular application.
\item The documentation in this guide does not describe the mechanism to
convert the access token into AWS Auth (“sigv4”) credentials for use
with IAM-protected AWS service endpoints. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/PortalAPIReference/API_GetRoleCredentials.html}{GetRoleCredentials}
in the \emph{IAM Identity Center Portal API Reference Guide}.
}

For general information about IAM Identity Center, see \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html}{What is IAM Identity Center?}
in the \emph{IAM Identity Center User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssooidc(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:ssooidc_create_token]{create_token} \tab Creates and returns an access token for the authorized client\cr
\link[paws.security.identity:ssooidc_register_client]{register_client} \tab Registers a client with IAM Identity Center\cr
\link[paws.security.identity:ssooidc_start_device_authorization]{start_device_authorization} \tab Initiates device authorization by requesting a pair of verification codes from the authorization service
}
}

\examples{
\dontrun{
svc <- ssooidc()
svc$create_token(
  Foo = 123
)
}

}
