% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{costandusagereportservice}
\alias{costandusagereportservice}
\title{AWS Cost and Usage Report Service}
\usage{
costandusagereportservice(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
You can use the Amazon Web Services Cost and Usage Report API to
programmatically create, query, and delete Amazon Web Services Cost and
Usage Report definitions.

Amazon Web Services Cost and Usage Report track the monthly Amazon Web
Services costs and usage associated with your Amazon Web Services
account. The report contains line items for each unique combination of
Amazon Web Services product, usage type, and operation that your Amazon
Web Services account uses. You can configure the Amazon Web Services
Cost and Usage Report to show only the data that you want, using the
Amazon Web Services Cost and Usage Report API.

Service Endpoint

The Amazon Web Services Cost and Usage Report API provides the following
endpoint:
\itemize{
\item cur.us-east-1.amazonaws.com
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- costandusagereportservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.cost.management:costandusagereportservice_delete_report_definition]{delete_report_definition} \tab Deletes the specified report\cr
\link[paws.cost.management:costandusagereportservice_describe_report_definitions]{describe_report_definitions} \tab Lists the Amazon Web Services Cost and Usage Report available to this account\cr
\link[paws.cost.management:costandusagereportservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags associated with the specified report definition\cr
\link[paws.cost.management:costandusagereportservice_modify_report_definition]{modify_report_definition} \tab Allows you to programmatically update your report preferences\cr
\link[paws.cost.management:costandusagereportservice_put_report_definition]{put_report_definition} \tab Creates a new report using the description that you provide\cr
\link[paws.cost.management:costandusagereportservice_tag_resource]{tag_resource} \tab Associates a set of tags with a report definition\cr
\link[paws.cost.management:costandusagereportservice_untag_resource]{untag_resource} \tab Disassociates a set of tags from a report definition
}
}

\examples{
\dontrun{
svc <- costandusagereportservice()
# The following example deletes the AWS Cost and Usage report named
# ExampleReport.
svc$delete_report_definition(
  ReportName = "ExampleReport"
)
}

}
