% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.r
\name{pcoords}
\alias{pcoords}
\alias{base.pnum}
\alias{base.pcoord}
\title{Interchange Between Process Number and BLACS Coordinates}
\usage{
base.pnum(ICTXT, PROW, PCOL)

base.pcoord(ICTXT, PNUM)
}
\arguments{
\item{ICTXT}{BLACS context number.}

\item{PROW, PCOL}{BLACS grid location row/column}

\item{PNUM}{process rank}
}
\value{
\code{pnum} returns an integer; \code{pcoord} returns a list
containing elements \code{PROW} and \code{PCOL}.
}
\description{
Grabs the existing BLACS context grid information.
}
\details{
For advanced users only. These functions are simple recreations of the BLACS
routines \code{BLACS_PNUM} and \code{BLACS_PCOORD}. The former gets the
process number associated with the BLACS process grid location
\code{c(MYPROW, MYPCOL)}, while the latter does the reverse.
}
\examples{
spmd.code <- "
  suppressMessages(library(pbdMPI))
  suppressMessages(library(pbdBASE))
  init.grid()

  ### get the ICTXT = 0 BLACS coordsinates for process 3
  myCoords <- base.pcoord(ICTXT = 0, PNUM = 3)
  comm.print(myCoords)

  ### get the ICTXT = 1 BLACS coordsinates for process 3
  myCoords <- base.pcoord(ICTXT = 1, PNUM = 3)
  comm.print(myCoords)

  ### get the ICTXT = 2 BLACS coordsinates for process 3
  myCoords <- base.pcoord(ICTXT = 2, PNUM = 3)
  comm.print(myCoords)

  finalize()
"
pbdMPI::execmpi(spmd.code = spmd.code, nranks = 4L)

}
\keyword{BLACS}
