% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_print.r
\docType{methods}
\name{ddmatrix-print}
\alias{ddmatrix-print}
\alias{print}
\alias{print,ddmatrix-method}
\alias{show,ddmatrix-method}
\title{Printing a Distributed Matrix}
\usage{
print(x, ...)

\S4method{print}{ddmatrix}(x, ..., all = FALSE, name = "x")

\S4method{show}{ddmatrix}(object)
}
\arguments{
\item{x, object}{numeric distributed matrix}

\item{...}{additional arguments}

\item{all}{control for whether the entire distributed matrix should be
printed to standard output}

\item{name}{character string that will be printed to standard output along
with the matrix elements}
}
\value{
The function silently returns 0.
}
\description{
Print method for a distributed matrices.
}
\details{
Print method for class \code{ddmatrix}.

If argument \code{all=TRUE}, then a modified version of the ScaLAPACK TOOLS
routine PDLAPRNT is used to print the entire distributed matrix.  The matrix
will be printed in column-major fashion, with one element of the matrix per
line. If \code{all=FALSE} then the \code{name=} argument is ignored.
}
\examples{

\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:16, ncol=4)
dx <- as.ddmatrix(x) 

print(dx)

print(dx, all=T)

finalize()
}

}
\keyword{Methods}

