#' Physical activity flow propensity
#'
#' A dataset containing paired comparisons of 87 physical activities on 16
#' flow-related facets. Participants submitted two activities using free-form
#' input. These activities were substitute into item templates.
#' For example, the \sQuote{predict} item asked,
#' \dQuote{How predictable is the action?} with response options:
#' \itemize{
#' \item A1 is much more predictable than A2.
#'  \item A1 is somewhat more predictable than A2.
#'  \item Both offer roughly equal predictability.
#'  \item A2 is somewhat more predictable than A1.
#'  \item A2 is much more predictable than A1.
#' }
#'  Most items were adapted from Jackson & Eklund (2002).
#' @format
#' A data.frame with one row per activity comparison and items in
#' the columns. All item responses are between -2 and 2. Zero indicates
#' that both activities were judged equal on the trait.
#' @source
#' A manuscript fully describing the study is in preparation.
#' Data are made available under the \href{https://cdla.dev/sharing-1-0/}{Community Data License Agreement - Sharing - Version 1.0}
#' @references
#' Jackson, S. A., & Eklund, R. C. (2002). Assessing flow in physical activity: The flow state
#' scale-2 and dispositional flow scale-2. \emph{Journal of Sport and Exercise Psychology, 24}(2),
#' 133-150. doi:10.1123/jsep.24.2.133
"phyActFlowPropensity"
