% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.pcLasso.R
\name{predict.cv.pcLasso}
\alias{predict.cv.pcLasso}
\title{Make predictions from a "cv.pcLasso" object}
\usage{
\method{predict}{cv.pcLasso}(object, xnew, s = c("lambda.1se",
  "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted "\code{cv.pcLasso}" object.}

\item{xnew}{Matrix of new values for \code{x} at which predictions are to
be made.}

\item{s}{Value of the penalty parameter \code{lambda} at which predictions are
required. Default is the value \code{s="lambda.1se"} stored in the CV
\code{fit}. Alternatively, \code{s="lambda.min"} can be used.}

\item{...}{Potentially other arguments to be passed to and from methods;
currently not in use.}
}
\value{
Predictions which the cross-validated model makes for \code{xnew} at
the optimal value of \code{lambda}. Note that the default is the "lambda.1se" for lambda,
to make this function consistent with cv.glmnet in the glmnet pkg.
The output is predictions of \eqn{E(y|xnew)}: these are probabilities for the 
binomial family.
}
\description{
This function returns the predictions for a new data matrix from a
cross-validated pcLasso model by using the stored "\code{glmfit}" object and
the optimal value chosen for \code{lambda}.
}
\details{
This function makes it easier to use the results of cross-validation to make
a prediction. Note that \code{xnew} should have the same number of columns as
the original feature space, regardless of whether the groups are overlapping
or not.
}
\examples{
set.seed(1)
x <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)

cvfit <- cv.pcLasso(x, y, ratio = 0.8)
predict(cvfit, xnew = x[1:5, ])
predict(cvfit, xnew = x[1:5, ], s = "lambda.min")

}
\seealso{
\code{\link{cv.pcLasso}} and \code{\link{predict.pcLasso}}.
}
