% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{IedgeCStri}
\alias{IedgeCStri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
one triangle case}
\usage{
IedgeCStri(
  p1,
  p2,
  tri,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p2} or not
in the underlying or reflexivity graphs of CS-PCDs.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of CS-PCDs
in a given triangle \code{tri}, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of CS-PCDs \eqn{)}
for points \code{p1} and \code{p2} in a given triangle.

More specifically, when the argument \code{ugraph="underlying"}, it returns
the edge indicator for the CS-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} or \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for the CS-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} and \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.

In both cases CS proximity region is constructed
with respect to the triangle \code{tri} and
edge regions are based on the center, \eqn{M=(m_1,m_2)}
in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \code{tri}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations
(i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
M<-as.numeric(pcds::runif.tri(1,Tr)$g)

t<-1.5
n<-3
set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

IedgeCStri(Xp[1,],Xp[2,],Tr,t,M)
IedgeCStri(Xp[1,],Xp[2,],Tr,t,M,ugraph = "reflexivity")

P1<-as.numeric(pcds::runif.tri(1,Tr)$g)
P2<-as.numeric(pcds::runif.tri(1,Tr)$g)
IedgeCStri(P1,P2,Tr,t,M)
IedgeCStri(P1,P2,Tr,t,M,ugraph="r")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgeCSbasic.tri}}, \code{\link{IedgeAStri}},
\code{\link{IedgePEtri}} and \code{\link[pcds]{IarcCStri}}
}
\author{
Elvan Ceyhan
}
