% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndCSTe}
\alias{IndCSTe}
\title{The indicator for the presence of an arc from a point to another for Central Similarity Proximity Catch
Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
IndCSTe(pt1, pt2, t, M = c(1, 1, 1), re = NULL)
}
\arguments{
\item{pt1}{A 2D point whose CS proximity region is constructed.}

\item{pt2}{A 2D point. The function determines whether \code{pt2} is inside the CS proximity region of
\code{pt1} or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}}

\item{re}{The index of the edge region in \eqn{T_e} containing the point, either 1, 2, 3 or \code{NULL}
(default is \code{NULL})}
}
\value{
I(\code{pt2} is in \eqn{NCS(pt1,t)}) for \code{pt1}, that is, returns 1 if \code{pt2} is in \eqn{NCS(pt1,t)}, returns 0 otherwise
}
\description{
Returns I(\code{pt2} is in \eqn{NCS(pt1,t)}) for points \code{pt1} and \code{pt2}, that is, returns 1 if \code{pt2} is in \eqn{NCS(pt1,t)},
returns 0 otherwise, where \eqn{NCS(x,t)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t>0}.

CS proximity region is defined with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \eqn{T_e}.
\code{re} is the index of the edge region \code{pt1} resides, with default=\code{NULL}.

If \code{pt1} and \code{pt2} are distint and either of them are outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

t<-1

IndCSTe(dat[1,],dat[2,],t,M)
IndCSTe(dat[1,],dat[1,],t,M)

IndCSTe(dat[1,],dat[2,],t=4,M)
IndCSTe(dat[2,],dat[5,],t,M)
IndCSTe(c(.2,.5),dat[2,],t,M)

IndCSTe(c(.2,.5),c(.2,.5),t,M)

#or try
re<-reTeCM(dat[1,])$re
IndCSTe(dat[1,],dat[2,],t,M,re=re)

IndCSTe(dat[1,],dat[2,],t,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCStri}} and \code{\link{IndNPETe}}
}
