% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{plot.TriLines}
\alias{plot.TriLines}
\title{Plot a \code{TriLines} object}
\usage{
\method{plot}{TriLines}(x, xlab = "x", ylab = "y", ...)
}
\arguments{
\item{x}{Object of class \code{TriLines}}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default is \code{xlab}="x" and \code{ylab}="y".)}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the line together with the defining triangle.
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
xfence<-abs(A[1]-B[1])*.25 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by=.01)

lnACM<-lA_CM.Te(x)
lnACM
plot(lnACM)
}

}
\seealso{
\code{\link{print.TriLines}}, \code{\link{summary.TriLines}}, and \code{\link{print.summary.TriLines}}
}
