% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{dist.pt2set}
\alias{dist.pt2set}
\title{Distance from a point to a set of finite cardinality}
\usage{
dist.pt2set(x, Y)
}
\arguments{
\item{x}{A vector (i.e., a point in \eqn{R^d}).}

\item{Y}{A set of d-dimensional points.}
}
\value{
A list with the elements
\item{distance}{Distance from point \code{x} to set \code{Y}}
\item{ind.cl.point}{Index of the closest point in set \code{Y} to the point \code{x}}
\item{closest.point}{The closest point in set \code{Y} to the point \code{x}}
}
\description{
Returns the Euclidean distance between a point \code{x} and set of points \code{Y} and the
closest point in set \code{Y} to \code{x}. Distance between a point and a set is by definition the distance
from the point to the closest point in the set. \code{x} should be of finite dimension and \code{Y} should
be of finite cardinality and \code{x} and elements of \code{Y} must have the same dimension.
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
dist.pt2set(c(1,2),Te)

X2<-cbind(runif(10),runif(10))
dist.pt2set(c(1,2),X2)

dist.pt2set(C,C)
dist.pt2set(B,C)

\dontrun{
x<-runif(1)
y<-runif(10)
dist.pt2set(x,y)
#this does not work because both entries are treated as vectors
}

x<-runif(1)
y<-as.matrix(runif(10))
dist.pt2set(x,y)  #this works, because x is a 1D point, and y is treated as a set of 10 1D points

dat.fr<-data.frame(b=B,c=C)
dist.pt2set(A,dat.fr)

}
\seealso{
\code{\link{dp2l}} and \code{\link{dp2pl}}
}
