% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{print.Lines}
\alias{print.Lines}
\title{Print a \code{Lines} object}
\usage{
\method{print}{Lines}(x, ...)
}
\arguments{
\item{x}{A \code{Lines} object.}

\item{\dots}{Additional arguments for the S3 method '\code{print}'.}
}
\value{
The \code{call} of the object of class '\code{Lines}'
and the \code{coefficients} of the line (in the form: y = slope * x + intercept).
}
\description{
Prints the \code{call} of the object of class '\code{Lines}'
and also the \code{coefficients} of the line (in the form: y = slope * x + intercept).
}
\examples{
A<-c(-1.22,-2.33); B<-c(2.55,3.75)
xr<-range(A,B);
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=100)

lnAB<-Line(A,B,x)
lnAB
print(lnAB)

}
\seealso{
\code{\link{summary.Lines}}, \code{\link{print.summary.Lines}}, and \code{\link{plot.Lines}}
}
