% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPEMT}
\alias{NumArcsPEMT}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - multiple triangle case}
\usage{
NumArcsPEMT(Xp, Yp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle (for this argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)} which is the center of mass of each triangle.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Total number of arcs in all triangles}
\item{num.in.conhull}{Number of \code{Xp} points in the convex hull of \code{Yp} points}
\item{weight.vec}{The \code{vector} of the areas of Delaunay triangles based on \code{Yp} points}
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) whose vertices are
the data points in \code{Xp} in the multiple triangle case.

PE proximity regions are defined with respect to the
Delaunay triangles based on \code{Yp} points with expansion parameter \eqn{r \ge 1} and vertex regions in each triangle
is based on the center \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of each
Delaunay triangle or based on circumcenter of each Delaunay triangle (default for \eqn{M=(1,1,1)}
which is the center of mass of the triangle).
Each Delaunay triangle is first converted to an (unscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle (this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). For the number of arcs, loops are not allowed so arcs are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE;textual}{pcds}) for more on PE-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny),runif(ny))

oldpar <- par(no.readonly = TRUE)
plotDeltri(Xp,Yp,xlab="",ylab="")
par(oldpar)

M<-c(1,1,1)  #try also M<-c(1,2,3)

NumArcsPEMT(Xp,Yp,r=1.25,M)
NumArcsPEMT(Xp,Yp,r=1.5,M)
NumArcsPEMT(Xp,Yp,r=2,M)

NumArcsPEMT(c(.4,.2),Yp,r=1.25)

r<-2
NumArcsPEMT(Xp,Yp,r)
NumArcsPEMT(Xp,Yp[1:3,],r)

NumArcsPEMT(Xp,rbind(Yp,Yp),r)

dat.fr<-data.frame(a=Xp)
NumArcsPEMT(dat.fr,Yp,r)

dat.fr<-data.frame(a=Yp)
NumArcsPEMT(Xp,dat.fr,r)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEtri}}, \code{\link{NumArcsPETe}}, \code{\link{NumArcsCSMT}},
and \code{\link{NumArcsASMT}}
}
\author{
Elvan Ceyhan
}
