% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam1ASbastri}
\alias{Gam1ASbastri}
\title{The indicator for a point being a dominating point for Arc Slice Proximity Catch Digraphs
(AS-PCDs) - basic triangle case}
\usage{
Gam1ASbastri(p, Dt, c1, c2, M = "CC", rv = NULL, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point or not of the AS-PCD.}

\item{Dt}{A set of 2D points which constitutes the vertices of the AS-PCD.}

\item{c1, c2}{Positive real numbers which constitute the vertex of the basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \eqn{T_b} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \eqn{T_b}.}

\item{rv}{Index of the vertex whose region contains point \code{p}, \code{rv} takes the vertex labels as \eqn{1,2,3} as
in the row order of the vertices in \eqn{T_b}.}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point in \code{Dt} or not
(default is \code{FALSE}).}
}
\value{
I(\code{p} is a dominating point of the AS-PCD) where the vertices of the AS-PCD are the 2D data set \code{Dt},
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns I(\code{p} is a dominating point of the AS-PCD) where the vertices of the AS-PCD are the 2D data set \code{Dt}, that is, returns 1 if \code{p} is a dominating
point of AS-PCD, returns 0 otherwise. AS proximity regions are defined with respect to the basic triangle,
\eqn{T_b}, \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence basic triangle is useful for simulation
studies under the uniformity hypothesis.

Vertex regions are based on the center \code{M="CC"} for circumcenter
of \eqn{T_b}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of \eqn{T_b}; default is \code{M="CC"}.
Point, \code{p}, is in the vertex region of vertex \code{rv} (default is \code{NULL}); vertices are labeled as \eqn{1,2,3}
in the order they are stacked row-wise.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Dt} or not (default is \code{FALSE}),
so by default this function checks whether the point \code{p} would be a dominating point
if it actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-20

set.seed(1)
dat<-runif.bastri(n,c1,c2)$g

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.2)

Gam1ASbastri(dat[1,],dat,c1,c2,M)

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Gam1ASbastri(dat[i,],dat,c1,c2,M))}

ind.gam1<-which(gam.vec==1)
ind.gam1

#or try
Rv<-rv.bastriCC(dat[1,],c1,c2)$rv
Gam1ASbastri(dat[1,],dat,c1,c2,M,Rv)

Gam1ASbastri(c(.2,.4),dat,c1,c2,M)
Gam1ASbastri(c(.2,.4),c(.2,.4),c1,c2,M)

dat2<-rbind(dat,c(.2,.4))
Gam1ASbastri(dat[1,],dat2,c1,c2,M)

CC<-circ.cent.bastri(c1,c2)  #the circumcenter

if (dimension(M)==3) {M<-bary2cart(M,Tb)}
#need to run this when M is given in barycentric coordinates

if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-cp2e.bastri(c1,c2,M)
D1<-Ds[1,]; D2<-Ds[2,]; D3<-Ds[3,]
}

Xlim<-range(Tb[,1],dat[,1])
Ylim<-range(Tb[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",xlab="",ylab="",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-rbind(cent,cent,cent); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(dat)
points(rbind(dat[ind.gam1,]),pch=4,col=2)

txt<-rbind(Tb,cent,D1,D2,D3)
xc<-txt[,1]+c(-.03,.03,.02,.06,.06,-0.05,.01)
yc<-txt[,2]+c(.02,.02,.03,.0,.03,.03,-.03)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)

Gam1ASbastri(c(.4,.2),dat,c1,c2,M)

dat.fr<-data.frame(a=dat)
Gam1ASbastri(c(.4,.2),dat.fr,c1,c2,M)

Gam1ASbastri(c(.5,.11),dat,c1,c2,M)

Gam1ASbastri(c(.5,.11),dat,c1,c2,M,ch.data.pnt=FALSE)
#gives an error message if ch.data.pnt=TRUE since the point is not in the basic triangle

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam1AStri}} and \code{\link{Gam1PEbastri}}
}
\author{
Elvan Ceyhan
}
