% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{print.Lines3D}
\alias{print.Lines3D}
\title{Print a \code{Lines3D} \code{object}}
\usage{
\method{print}{Lines3D}(x, ...)
}
\arguments{
\item{x}{A \code{Lines3D} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"Lines3D"},
the \code{coefficients} of the line (in the form: \code{x=x0 + a*t}, \code{y=y0 + b*t}, and \code{z=z0 + c*t}),
and the initial point together with the direction vector.
}
\description{
Prints the \code{call} of the \code{object} of class \code{"Lines3D"},
the \code{coefficients} of the line (in the form: \code{x=x0 + a*t}, \code{y=y0 + b*t}, and \code{z=z0 + c*t}),
and the initial point together with the direction vector.
}
\examples{
A<-c(1,10,3); B<-c(1,1,3);
vecs<-rbind(A,B)
Line3D(A,B,.1)
Line3D(A,B,.1,dir.vec=FALSE)

tr<-range(vecs);
tf<-(tr[2]-tr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
tsq<-seq(-tf*10-tf,tf*10+tf,l=100)

lnAB3D<-Line3D(A,B,tsq)
lnAB3D
print(lnAB3D)

}
\seealso{
\code{\link{summary.Lines3D}}, \code{\link{print.summary.Lines3D}}, and \code{\link{plot.Lines3D}}
}
