% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{Gam1CS.Te.onesixth}
\alias{Gam1CS.Te.onesixth}
\title{The indicator for a point being a dominating point for Central Similarity Proximity Catch Digraphs (CS-PCDs)
- first one-sixth of the standard equilateral triangle case}
\usage{
Gam1CS.Te.onesixth(p, Xp, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point or not of the CS-PCD.}

\item{Xp}{A set of 2D points which constitutes the vertices of the CS-PCD.}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\code{p} is a dominating point of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Xp},
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p} is a dominating point of the 2D data set \code{Xp} of CS-PCD\eqn{)} in the standard equilateral
triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}, that is, returns 1 if \code{p} is a dominating point of CS-PCD,
returns 0 otherwise.

Point, \code{p}, must lie in the first one-sixth of \eqn{T_e}, which is the triangle with vertices
\eqn{T(A,D_3,CM)=T((0,0),(1/2,0),CM)}.

CS proximity region is constructed with respect to \eqn{T_e} with expansion parameter \eqn{t=1}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Xp} or not (default is \code{FALSE}),
so by default this function checks whether the point \code{p} would be a dominating point if it actually were in the data
set.

See also (\insertCite{ceyhan:Phd-thesis;textual}{pcds}).
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam1CSTe}} and \code{\link{Gam1CSTet1}}
}
\author{
Elvan Ceyhan
}
