% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{Gam1CSint}
\alias{Gam1CSint}
\title{The indicator for a point being a dominating point for Central Similarity
Proximity Catch Digraphs (CS-PCDs) for an interval}
\usage{
Gam1CSint(p, Xp, int, t, c = 0.5, rv = NULL, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 1D point that is to be tested for being a dominating point or not of the CS-PCD.}

\item{Xp}{A set of 1D points which constitutes the vertices of the CS-PCD.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{rv}{Index of the vertex region in which the point resides, either \code{1,2} or \code{NULL}
(default is \code{NULL}).}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\code{p} is a dominating point of CS-PCD\eqn{)} where the vertices of the CS-PCD are the 1D data set \code{Xp}),
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p} is a dominating point of CS-PCD\eqn{)} where the vertices of the CS-PCD are the 1D data set \code{Xp}).

CS proximity region is defined with respect to the interval \code{int} with an expansion parameter, \eqn{t>0},
and a centrality parameter, \eqn{c \in (0,1)}, so arcs may exist for \code{Xp} points inside the interval \code{int}\eqn{=(a,b)}.

Vertex regions are based on the center associated with the centrality parameter \eqn{c \in (0,1)}.
\code{rv} is the index of the vertex region \code{p} resides, with default=\code{NULL}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Xp} or not (default is \code{FALSE}),
so by default this function checks whether the point \code{p} would be a dominating point
if it actually were in the data set.
}
\examples{
\dontrun{
t<-2
c<-.4
a<-0; b<-10; int<-c(a,b)

Mc<-centMc(int,c)
n<-10

set.seed(1)
Xp<-runif(n,a,b)

Gam1CSint(Xp[5],Xp,int,t,c)

Gam1CSint(2,Xp,int,t,c,ch.data.pnt = FALSE)
#gives an error if ch.data.pnt = TRUE since p is not a data point in Xp

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Gam1CSint(Xp[i],Xp,int,t,c))}

ind.gam1<-which(gam.vec==1)
ind.gam1

domset<-Xp[ind.gam1]
if (length(ind.gam1)==0)
{domset<-NA}

#or try
Rv<-rv.mid.int(Xp[5],int,c)$rv
Gam1CSint(Xp[5],Xp,int,t,c,Rv)

Xlim<-range(a,b,Xp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),xlab="",pch=".",xlim=Xlim+xd*c(-.05,.05))
abline(h=0)
abline(v=c(a,b,Mc),col=c(1,1,2),lty=2)
points(cbind(Xp,0))
points(cbind(domset,0),pch=4,col=2)
text(cbind(c(a,b,Mc),-0.1),c("a","b","Mc"))
}

}
\seealso{
\code{\link{Gam1PEint}}
}
\author{
Elvan Ceyhan
}
