% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{IndNCSdomUBTe}
\alias{IndNCSdomUBTe}
\title{The indicator for \code{k} being an upper bound for the domination number of Central Similarity Proximity
Catch Digraph (CS-PCD) by the exact algorithm - standard equilateral triangle case}
\usage{
IndNCSdomUBTe(Xp, k, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of CS-PCD.}

\item{k}{A positive integer representing an upper bound for the domination number of CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region in the
standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
A \code{list} with two elements
\item{domUB}{The upper bound \code{k} (to be checked) for the domination number of CS-PCD. It is prespecified
as \code{k} in the function arguments.}
\item{IndUBdom}{The indicator for the upper bound for domination number of CS-PCD being the
specified value \code{k} or not. It returns 1 if the upper bound is \code{k}, and 0 otherwise.}
\item{ind.domset}{The vertices (i.e., data points) in the dominating set of size \code{k} if it exists,
otherwise it is \code{NULL}.}
}
\description{
Returns \eqn{I(}domination number of CS-PCD is less than or equal to \code{k}\eqn{)} where the vertices of the CS-PCD are the data points \code{Xp},
that is, returns 1 if the domination number of CS-PCD is less than the prespecified value \code{k}, returns 0
otherwise. It also provides the vertices (i.e., data points) in a dominating set of size \code{k} of CS-PCD.

CS proximity region is constructed with respect to the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with
expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e} (which is equivalent to the circumcenter of \eqn{T_e}).

Edges of \eqn{T_e}, \eqn{AB}, \eqn{BC}, \eqn{AC}, are also labeled as 3, 1, and 2, respectively.
Loops are allowed in the digraph.
It takes a long time for large number of vertices (i.e., large number of row numbers).

See also (\insertCite{ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

t<-.5

IndNCSdomUBTe(Xp,1,t,M)

for (k in 1:n)
  print(c(k,IndNCSdomUBTe(Xp,k,t,M)$IndUBdom))
  print(c(k,IndNCSdomUBTe(Xp,k,t,M)$domUB))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCSdomUBtri}}, \code{\link{IndUBdom}}, \code{\link{IndASdomUBtri}},
and \code{\link{dom.exact}}
}
\author{
Elvan Ceyhan
}
