% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{IndNCSmid.int}
\alias{IndNCSmid.int}
\title{The indicator for the presence of an arc from a point to another for Central Similarity
Proximity Catch Digraphs (CS-PCDs) - middle interval case}
\usage{
IndNCSmid.int(p1, p2, int, t, c = 0.5, rv = NULL)
}
\arguments{
\item{p1, p2}{1D points; \eqn{p_1} is the point for which the proximity region, \eqn{N_{CS}(p_1,t,c)} is
constructed and \eqn{p_2} is the point which the function is checking whether its inside
\eqn{N_{CS}(p_1,t,c)} or not.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{rv}{Index of the end interval containing the point, either \code{1,2} or \code{NULL} (default is \code{NULL}).}
}
\value{
\eqn{I(p_2} in \eqn{N_{CS}(p_1,t,c))} for points \eqn{p_1} and \eqn{p_2} that is, returns 1 if \eqn{p_2} is in \eqn{N_{CS}(p_1,t,c)},
returns 0 otherwise
}
\description{
Returns \eqn{I(p_2} in \eqn{N_{CS}(p_1,t,c))} for points \eqn{p_1} and \eqn{p_2}, that is, returns 1 if \eqn{p_2} is in \eqn{N_{CS}(p_1,t,c)}, returns 0
otherwise, where \eqn{N_{CS}(x,t,c)} is the CS proximity region for point \eqn{x} and is constructed with expansion
parameter \eqn{t>0} and centrality parameter \eqn{c \in (0,1)} for the interval \eqn{(a,b)}.

CS proximity regions are defined with respect to the middle interval \code{int} and vertex regions are based
on the center associated with the centrality parameter \eqn{c \in (0,1)}. For the interval, \code{int}\eqn{=(a,b)}, the
parameterized center is \eqn{M_c=a+c(b-a)}. \code{rv} is the index of the vertex region \eqn{p_1} resides, with default=\code{NULL}.

If \eqn{p_1} and \eqn{p_2} are distinct and either of them are outside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations
(i.e., loops are allowed in the digraph).

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
\dontrun{
c<-.5
t<-2
a<-0; b<-10; int<-c(a,b)

IndNCSmid.int(7,5,int,t,c)
IndNCSmid.int(1,3,int,t,c)

#or try
Rv<-rv.mid.int(3,int,c)$rv
IndNCSmid.int(3,5,int,t,c,rv=Rv)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCSend.int}}, \code{\link{IndNPEmid.int}}, and \code{\link{IndNPEend.int}}
}
\author{
Elvan Ceyhan
}
