% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{CSarcdens.tri}
\alias{CSarcdens.tri}
\title{Arc density of Central Similarity Proximity Catch Digraphs (CS-PCDs) - one triangle case}
\usage{
CSarcdens.tri(Xp, tri, t, M = c(1, 1, 1), tri.cor = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}

\item{tri.cor}{A logical argument for computing the arc density for only the points inside the triangle,
\code{tri} (default is \code{tri.cor=FALSE}), i.e., if \code{tri.cor=TRUE} only the induced digraph with the vertices
inside \code{tri} are considered in the computation of arc density.}
}
\value{
A \code{list} with the elements
\item{arc.dens}{Arc density of CS-PCD whose vertices are the 2D numerical data set, \code{Xp};
CS proximity regions are defined with respect to the triangle \code{tri} and \code{M}-edge regions}
\item{std.arc.dens}{Arc density standardized by the mean and asymptotic variance of the arc
density of CS-PCD for uniform data in the triangle \code{tri}.This will only be returned if \code{M} is the center of mass.}
}
\description{
Returns the arc density of CS-PCD whose vertex set is the given 2D numerical data set, \code{Xp},
(some of its members are) in the triangle \code{tri}.

CS proximity regions is defined with respect to \code{tri} with
expansion parameter \eqn{t>0} and edge regions are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}; default is
\eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.
The function also provides arc density standardized by the mean and asymptotic variance of the arc density
of CS-PCD for uniform data in the triangle \code{tri}
only when \code{M} is the center of mass. For the number of arcs, loops are not allowed.

\code{tri.cor} is a logical argument for triangle correction (default is \code{TRUE}), if \code{TRUE}, only the points inside the
triangle are considered (i.e., digraph induced by these vertices are considered) in computing the arc density,
otherwise all points are considered (for the number of vertices in the denominator of arc density).

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}) for more on CS-PCDs.
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

CSarcdens.tri(Xp,Tr,t=.5,M)
CSarcdens.tri(Xp,Tr,t=.5,M,tri.cor = FALSE)
#try also t=1 and t=1.5 above
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ASarcdens.tri}}, \code{\link{PEarcdens.tri}}, and \code{\link{NumArcsCStri}}
}
\author{
Elvan Ceyhan
}
