% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{IndNCStri}
\alias{IndNCStri}
\title{The indicator for the presence of an arc from one point to another for Central Similarity Proximity
Catch Digraphs (CS-PCDs)}
\usage{
IndNCStri(p1, p2, tri, t, M, re = NULL)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the CS proximity region of
\code{p1} or not.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}

\item{re}{Index of the \code{M}-edge region containing the point \code{p},
either \code{1,2,3} or \code{NULL} (default is \code{NULL}).}
}
\value{
I(\code{p2} is in \eqn{NCS(p1,t)}) for \code{p1}, that is, returns 1 if \code{p2} is in \eqn{NCS(p1,t)}, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t))} for points \code{p1} and \code{p2}, that is,
returns 1 if \code{p2} is in \eqn{NCS(p1,t)},
returns 0 otherwise, where \eqn{N_{CS}(x,t)} is the CS proximity region for point \eqn{x} with the expansion parameter \eqn{t>0}.

CS proximity region is constructed with respect to the triangle \code{tri} and
edge regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \code{tri}
or based on the circumcenter of \code{tri}.
\code{re} is the index of the edge region \code{p} resides, with default=\code{NULL}

If \code{p1} and \code{p2} are distinct and either of them are outside \code{tri}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
tau<-1.5

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

n<-10
set.seed(1)
Xp<-runif.tri(n,Tr)$g

IndNCStri(Xp[1,],Xp[2,],Tr,tau,M)

P1<-as.numeric(runif.tri(1,Tr)$g)
P2<-as.numeric(runif.tri(1,Tr)$g)
IndNCStri(P1,P2,Tr,tau,M)

#or try
re<-rel.edges.tri.cent(P1,Tr,M)$re
IndNCStri(P1,P2,Tr,tau,M,re)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNAStri}}, \code{\link{IndNPEtri}}, \code{\link{IndNCStri}}, and \code{\link{IndNCSTe}}
}
\author{
Elvan Ceyhan
}
