% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{my_round}
\alias{my_round}
\title{The function to round to \code{n} decimals or to the nearest non-zero decimal place, if rounding to \code{n} yields zero.}
\usage{
my_round(x, n = 2)
}
\arguments{
\item{x}{A real number on which rounding will be applied}

\item{n}{Number of decimal places to round the number. If rounding yields 0, it rounds to the nearest non-zero decimal place.}
}
\value{
The rounded number to \code{n} decimals, and if this is zero to the nearest nonzero decimal
}
\description{
Returns the rounded number to the \code{n} decimals or to the nearest non-zero decimal place,
if rounding to \code{n} decimals yields zero. The default for \code{n} is 2.
Function is borrowed from this
\href{https://stackoverflow.com/}{link}.
}
\examples{
a=17; b=35

my_round(a/b)
my_round(b/a)

my_round(12.5624)
my_round(-0.64010)
my_round (0.000026)
my_round(-0.00072451)

}
\seealso{
\code{\link[base]{round}} and \code{\link[base]{signif}}
}
\author{
Elvan Ceyhan
}
